/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dsd.tools.dsdwizard;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.TreeMap;
import org.dmd.dmc.DmcNameClashException;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.DmcValueExceptionSet;
import org.dmd.dmc.rules.DmcRuleExceptionSet;
import org.dmd.dsd.tools.dsdwizard.DSLArtifactGenerator;
import org.dmd.util.codegen.Manipulator;
import org.dmd.util.exceptions.DebugInfo;
import org.dmd.util.exceptions.ResultException;

public class DSDInteractive {
    String runningDir;
    String workspace;
    String project;
    TreeMap<String, ProjectInfo> projectsByName = new TreeMap();
    TreeMap<Integer, ProjectInfo> projectsByNumber = new TreeMap();
    BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
    ProjectInfo targetProject;
    String targetSourceFolder;
    String targetPackage;
    String targetFolder;
    String targetDslAbbrev;
    String targetModuleName;

    public DSDInteractive(String[] args) throws IOException {
        this.initialize(args);
    }

    public void run() throws IOException, ResultException, DmcValueException, DmcValueExceptionSet, DmcNameClashException, DmcRuleExceptionSet {
        if (this.findProjectAndSrc(this.runningDir)) {
            this.findOtherProjects();
            this.gatherInput();
            DSLArtifactGenerator generator = new DSLArtifactGenerator();
            generator.generateDSD(this.workspace, this.targetProject.name, this.targetSourceFolder, this.targetPackage, this.targetFolder, this.targetDslAbbrev, this.targetModuleName);
        } else {
            System.err.println("Not running in an Eclipse project");
        }
    }

    void initialize(String[] args) throws IOException {
        File curr = new File(".");
        this.runningDir = curr.getCanonicalPath();
        System.out.println("*** Running from: " + this.runningDir);
        int lastSlash = this.runningDir.lastIndexOf(File.separator);
        this.workspace = this.runningDir.substring(0, lastSlash);
        System.out.println("*** Workspace: " + this.workspace);
        this.project = this.runningDir.substring(lastSlash + 1);
    }

    boolean findProjectAndSrc(String dir) {
        boolean haveProject = false;
        boolean haveSrc = false;
        File rd = new File(dir);
        File[] files = rd.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].getName().equals(".project")) {
                haveProject = true;
            }
            if (!files[i].getName().equals("src") || !files[i].isDirectory()) continue;
            haveSrc = true;
        }
        return haveProject && haveSrc;
    }

    void gatherInput() throws IOException {
        String input = null;
        State state = State.getWorkspaceConfirmation;
        boolean done = false;
        while (!done) {
            switch (state) {
                case getWorkspaceConfirmation: {
                    System.out.println("You are running in the " + this.workspace + " workspace. Is that where you want to create the DSL? y/n");
                    input = this.getResponse().toLowerCase();
                    if (input.equals("y")) {
                        state = State.getProject;
                        break;
                    }
                    if (!input.equals("n")) break;
                    System.out.println("Okay, we're done - until we allow choice of workspace...");
                    System.exit(0);
                    break;
                }
                case getProject: {
                    int pnum;
                    System.out.println("Please specify the number of the project where you want to create the DSL: \n");
                    this.showProjects();
                    input = this.getResponse();
                    try {
                        pnum = Integer.decode(input);
                    }
                    catch (NumberFormatException ex) {
                        System.err.println("Not a valid number: " + input);
                        break;
                    }
                    if (pnum < 1 || pnum > this.projectsByName.size()) {
                        System.err.println("Not a valid number: " + input);
                        break;
                    }
                    this.targetProject = this.projectsByNumber.get(pnum);
                    System.out.println("We'll create the DSL in: " + this.targetProject.name + "\n");
                    state = State.getJavaSrcFolder;
                    break;
                }
                case getJavaSrcFolder: {
                    File tf;
                    System.out.println("By default, we generate the code beneath the \"src\" directory within your project.");
                    System.out.println("However, if you're creating a Maven project, the code is likely in src/main/java.");
                    System.out.println("Please specify the source folder e.g. src, src/main/java or something else:\n");
                    input = this.getResponse();
                    if (input.matches("[a-z][/a-z]*")) {
                        this.targetSourceFolder = input;
                        String testFolderName = this.workspace + File.separator + this.targetProject.name + File.separator + this.targetSourceFolder;
                        tf = new File(testFolderName);
                        if (!tf.exists()) {
                            System.err.println("Sorry, the target java source folder DOESN'T EXIST: " + testFolderName);
                            break;
                        }
                        System.out.println("Target java source folder: " + this.targetSourceFolder + "\n");
                        state = State.getPackage;
                        break;
                    }
                    System.err.println("Bad java source folder name: " + input + "\n");
                    break;
                }
                case getPackage: {
                    File tf;
                    System.out.println("Specify a new java package in which to create the DSL. This MUST be a new package.");
                    System.out.println("We won't try to generate the DSL into an existing package, due to the risk of overwriting existing files.");
                    input = this.getResponse();
                    if (input.matches("[a-z][a-z0-9.]*")) {
                        this.targetPackage = input;
                        String folder = input.replaceAll("\\.", File.separator);
                        this.targetFolder = this.workspace + File.separator + this.targetProject.name + File.separator + this.targetSourceFolder + File.separator + folder;
                        tf = new File(this.targetFolder);
                        if (tf.exists()) {
                            System.err.println("Sorry, the target folder already exists: " + this.targetFolder);
                            break;
                        }
                        System.out.println("Target source folder: " + this.targetFolder + "\n");
                        state = State.getDslAbbrev;
                        break;
                    }
                    System.err.println("Bad package name: " + input + "\n");
                    break;
                }
                case getDslAbbrev: {
                    System.out.println("Specify the abbreviation of your DSL. By convention, this will be the file extension");
                    System.out.println("of files that contain definitions associated with your DSL. It should 3-6 characters (or there abouts).");
                    System.out.println("It's useful to have a unique prefix for DSLs associated with your company or division,");
                    System.out.println("for example all dark-matter DSLs start with 'dm'.");
                    input = this.getResponse();
                    if (input.matches("[a-zA-Z][a-zA-Z]*")) {
                        this.targetDslAbbrev = input.toLowerCase();
                        this.targetModuleName = Manipulator.capFirstChar(input);
                        System.out.println("DSL file extension: " + this.targetDslAbbrev);
                        System.out.println("DSL module name:    " + this.targetModuleName + "Module");
                        done = true;
                        break;
                    }
                    System.err.println("The abbreviation should be letters only");
                    break;
                }
            }
        }
    }

    String getResponse() throws IOException {
        String input = this.in.readLine();
        if (input == null) {
            System.out.println("Exitting...");
            System.exit(0);
        }
        return input.trim();
    }

    void showProjects() {
        for (ProjectInfo pi : this.projectsByName.values()) {
            System.out.println(pi.number + "  " + pi.name);
        }
        System.out.println();
    }

    void findOtherProjects() throws IOException {
        DebugInfo.debug("Looking for projects from: " + this.workspace);
        File wsdir = new File(this.workspace);
        File[] files = wsdir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].isDirectory()) continue;
            DebugInfo.debug("Checking: " + files[i].getName());
            if (!this.findProjectAndSrc(files[i].getCanonicalPath())) continue;
            ProjectInfo pi = new ProjectInfo(files[i].getName());
            this.projectsByName.put(pi.name, pi);
        }
        int number = 1;
        for (ProjectInfo pi : this.projectsByName.values()) {
            pi.number = number++;
            System.out.println(pi.number + " " + pi.name);
            this.projectsByNumber.put(pi.number, pi);
        }
    }

    class ProjectInfo {
        String name;
        int number;

        ProjectInfo(String n) {
            this.name = n;
        }
    }

    static enum State {
        getWorkspaceConfirmation,
        getProject,
        getJavaSrcFolder,
        getPackage,
        getDslAbbrev;

    }
}

