/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dsd.tools.dsdwizard;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.dmd.util.exceptions.ResultException;

public class DSDSchemaGenerator {
    public static void generateSchema(String dir, String sharedp, String dmwp, String dsdname, String def1, String def2, String def3) throws ResultException, IOException {
        DSDSchemaGenerator.createDmsFile(dir, sharedp, dmwp, dsdname);
    }

    static void createDmsFile(String dir, String sharedp, String dmwp, String dsdname) throws ResultException, IOException {
        String ofn = dir + "/shared/dmdconfig/" + dsdname + ".dms";
        File dmsFile = new File(ofn);
        if (dmsFile.exists()) {
            throw new ResultException("Schema file already exists: " + ofn);
        }
        System.out.println("Generating schema: " + ofn);
        BufferedWriter out = new BufferedWriter(new FileWriter(ofn));
        out.write("SchemaDefinition\n");
        out.write("name            " + dsdname + "\n");
        out.write("schemaBaseID    200000\n");
        out.write("defFiles        attributes.dmd\n");
        out.write("defFiles        classes.dmd\n");
        out.write("schemaPackage   " + sharedp + "\n");
        out.write("dmwPackage      " + dmwp + "\n");
        out.write("description     Autogenerated by the dark-matter DSDWizard utility.\n");
        out.close();
        ofn = dir + "/shared/dmdconfig/attributes.dmd";
        out = new BufferedWriter(new FileWriter(ofn));
        out.close();
        ofn = dir + "/shared/dmdconfig/classes.dmd";
        out = new BufferedWriter(new FileWriter(ofn));
        out.close();
    }
}

