/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dsd.tools.dsdwizard;

import java.io.File;
import java.io.IOException;
import org.dmd.dsd.tools.dsdwizard.DSDSchemaGenerator;
import org.dmd.util.BooleanVar;
import org.dmd.util.exceptions.ResultException;
import org.dmd.util.parsing.CommandLine;

public class DSDWizard {
    StringBuffer help;
    CommandLine cl;
    BooleanVar helpFlag = new BooleanVar();
    StringBuffer workspace = new StringBuffer();
    StringBuffer srcdir = new StringBuffer();
    StringBuffer dsdname = new StringBuffer();
    StringBuffer def1 = new StringBuffer();
    StringBuffer def2 = new StringBuffer();
    StringBuffer def3 = new StringBuffer();
    String fullSrcdir;
    String sharedDir;
    String sharedDmdconfigDir;
    String sharedGenDir;
    String sharedPackage;
    String dmwDir;
    String serverDmdConfigDir;
    String serverGenDir;
    String serverExtendedDir;
    String dmwPackage;

    public DSDWizard(String[] args) {
        this.cl = new CommandLine();
        this.cl.addOption("-h", this.helpFlag, "Dumps the help message.");
        this.cl.addOption("-workspace", this.workspace, "Indicates the base workspace folder.");
        this.cl.addOption("-srcdir", this.srcdir, "Indicates the folder where the example code will be generated.");
        this.cl.addOption("-dsdname", this.dsdname, "The name of the domain specific definition pack you want to create.");
        this.cl.parseArgs(args);
    }

    public void run() throws ResultException, IOException {
        System.out.println("workspace: " + this.workspace);
        File ws = new File(this.workspace.toString());
        if (!ws.exists()) {
            ResultException rc = new ResultException("Workspace doesn't exist: " + this.workspace);
            throw rc;
        }
        if (!this.srcdir.toString().startsWith("/")) {
            this.srcdir = new StringBuffer("/" + this.srcdir.toString());
        }
        System.out.println("srcdir: " + this.srcdir);
        this.fullSrcdir = this.workspace.toString() + this.srcdir.toString();
        File src = new File(this.fullSrcdir);
        if (!src.exists()) {
            if (!src.mkdirs()) {
                ResultException rc = new ResultException("Couldn't create output directory: " + this.fullSrcdir);
                throw rc;
            }
            System.out.println("Created " + this.fullSrcdir);
        }
        this.sharedDir = this.fullSrcdir + "/shared";
        this.sharedGenDir = this.sharedDir + "/generated";
        this.sharedDmdconfigDir = this.sharedDir + "/dmdconfig";
        this.sharedPackage = (this.srcdir + "/shared").replaceAll("/", ".").replaceFirst(".", "");
        this.dmwDir = this.fullSrcdir + "/server";
        this.serverDmdConfigDir = this.fullSrcdir + "/server/dmdconfig";
        this.serverGenDir = this.fullSrcdir + "/server/generated";
        this.serverExtendedDir = this.fullSrcdir + "/server/extended";
        this.dmwPackage = (this.srcdir + "/server").replaceAll("/", ".").replaceFirst(".", "");
        System.out.println("Packages: " + this.sharedPackage + "  " + this.dmwPackage);
        this.createDir(this.sharedDir);
        this.createDir(this.sharedGenDir);
        this.createDir(this.sharedDmdconfigDir);
        this.createDir(this.serverGenDir);
        this.createDir(this.serverExtendedDir);
        this.createDir(this.serverDmdConfigDir);
        DSDSchemaGenerator.generateSchema(this.fullSrcdir, this.sharedPackage, this.dmwPackage, this.dsdname.toString(), this.def1.toString(), this.def2.toString(), this.def3.toString());
    }

    void createDir(String dir) throws ResultException {
        File folder = new File(dir);
        if (!folder.exists() && !folder.mkdirs()) {
            ResultException rc = new ResultException("Couldn't create directory: " + dir);
            throw rc;
        }
    }

    void initHelp() {
        this.help = new StringBuffer();
        this.help.append("dsdwizard -h -workspace -srcdir -dmdid -dsdname -basedef -def1 -def2 -def3\n");
        this.help.append("\n");
    }
}

