/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.dsd.tools.dsdwizard.generated.dmtdl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.TreeMap;
import org.dmd.dmc.DmcNameClashException;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.rules.DmcRuleExceptionSet;
import org.dmd.dmc.rules.SourceInfo;
import org.dmd.dmc.util.DmcUncheckedObject;
import org.dmd.dms.AttributeDefinition;
import org.dmd.dms.SchemaManager;
import org.dmd.dms.generated.dmw.AttributeDefinitionIterableDMW;
import org.dmd.dmv.shared.DmvRuleManager;
import org.dmd.dmw.DmwObjectFactory;
import org.dmd.dmw.DmwWrapper;
import org.dmd.templates.server.extended.Template;
import org.dmd.templates.server.generated.DmtdlSchemaAG;
import org.dmd.templates.server.util.TemplateMediator;
import org.dmd.util.exceptions.ResultException;
import org.dmd.util.parsing.ConfigFinder;
import org.dmd.util.parsing.ConfigLocation;
import org.dmd.util.parsing.ConfigVersion;
import org.dmd.util.parsing.DmcUncheckedOIFHandlerIF;
import org.dmd.util.parsing.DmcUncheckedOIFParser;

public class DsdwizardTemplateLoader
implements DmcUncheckedOIFHandlerIF {
    SchemaManager schema;
    DmcUncheckedOIFParser parser = new DmcUncheckedOIFParser(this);
    DmwObjectFactory factory;
    DmvRuleManager rules = new DmvRuleManager();
    ConfigFinder finder = new ConfigFinder(".dmt");
    ConfigLocation location;
    TreeMap<String, TemplateMediator> mediators = new TreeMap();
    public static TemplateMediator DmtdlFile = new TemplateMediator("DmtdlFile");
    public static Template _Comment;

    public DsdwizardTemplateLoader(ArrayList<String> paths, ArrayList<String> jars) throws ResultException, DmcValueException, DmcNameClashException {
        this.schema = new SchemaManager();
        DmtdlSchemaAG sd = new DmtdlSchemaAG();
        this.schema.manageSchema(sd);
        this.parser.dropLineContinuations();
        if (sd.getAttributeDefListSize() > 0) {
            AttributeDefinitionIterableDMW attrs = sd.getAttributeDefList();
            while (attrs.hasNext()) {
                AttributeDefinition ad = (AttributeDefinition)attrs.getNext();
                if (!ad.getPreserveNewlines().booleanValue()) continue;
                this.parser.addPreserveNewlinesAttribute(ad.getName().getNameString());
            }
        }
        this.finder.setSourceAndJarInfo(paths, jars);
        this.mediators.put("DmtdlFile", DmtdlFile);
        this.factory = new DmwObjectFactory(this.schema);
        _Comment = new Template();
        _Comment.setFile("DsdwizardTemplateLoader");
        _Comment.setLineNumber(1);
        _Comment.setFormat("\n// ::comment::");
        _Comment.initialize("::");
    }

    public void findAndLoadTemplate() throws ResultException, IOException, DmcValueException, DmcRuleExceptionSet, DmcNameClashException {
        for (TemplateMediator tm : this.mediators.values()) {
            tm.reset();
        }
        this.finder.findConfigs();
        ConfigVersion version = this.finder.getConfig("dsdwizard");
        if (version == null) {
            ResultException ex = new ResultException("Could not find template definition file: dsdwizard.dmt");
            ex.moreMessages(this.finder.getSearchInfo());
            throw ex;
        }
        this.location = version.getLatestVersion();
        this.parser.parseFile(this.location.getFileName(), this.location.isFromJAR());
    }

    @Override
    public void handleObject(DmcUncheckedObject uco, String infile, int lineNumber) throws ResultException, DmcValueException, DmcRuleExceptionSet, DmcNameClashException {
        Template template = null;
        DmwWrapper wrapper = null;
        try {
            wrapper = this.factory.createWrapper(uco);
            template = (Template)wrapper;
        }
        catch (ClassNotFoundException e) {
            ResultException ex = new ResultException("Unknown object class: " + uco.classes.get(0));
            ex.result.lastResult().fileName(infile);
            ex.result.lastResult().lineNumber(lineNumber);
            throw ex;
        }
        catch (ResultException ex) {
            ex.setLocationInfo(infile, lineNumber);
            throw ex;
        }
        catch (DmcValueException e) {
            ResultException ex = new ResultException();
            ex.addError(e.getMessage());
            if (e.getAttributeName() != null) {
                ex.result.lastResult().moreMessages("Attribute: " + e.getAttributeName());
            }
            ex.setLocationInfo(infile, lineNumber);
            throw ex;
        }
        catch (ClassCastException e) {
            ResultException ex = new ResultException();
            ex.addError("The following object is not valid in a .dmt file:\n\n" + wrapper.toOIF());
            ex.setLocationInfo(infile, lineNumber);
            throw ex;
        }
        template.setLineNumber(lineNumber);
        template.setFile(infile);
        try {
            this.rules.executeInitializers(template.getDmcObject());
            this.rules.executeAttributeValidation(template.getDmcObject());
            this.rules.executeObjectValidation(template.getDmcObject());
        }
        catch (DmcRuleExceptionSet ex) {
            ex.source(new SourceInfo(infile, lineNumber));
            throw ex;
        }
        TemplateMediator tm = this.mediators.get(template.getName().getNameString());
        if (tm == null) {
            ResultException ex = new ResultException("Template for an unknown Section: " + template.getName());
            ex.moreMessages("The Template must use one of the following names:");
            for (String n : this.mediators.keySet()) {
                ex.moreMessages(n);
            }
            ex.setLocationInfo(template.getFile(), template.getLineNumber());
            throw ex;
        }
        if (tm.getTemplate() != null) {
            ResultException ex = new ResultException("Duplicate Template for Section: " + template.getName());
            ex.moreMessages("Previously defined at line: " + tm.getTemplate().getLineNumber());
            ex.setLocationInfo(template.getFile(), template.getLineNumber());
            throw ex;
        }
        template.initialize("::");
        tm.setTemplate(template);
    }
}

