/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.templates.server.extended;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.TreeMap;
import org.dmd.dms.ClassDefinition;
import org.dmd.templates.server.extended.ContainedElement;
import org.dmd.templates.server.extended.ExtensionHook;
import org.dmd.templates.server.generated.dmw.ContainsIterableDMW;
import org.dmd.templates.server.generated.dmw.SectionDMW;
import org.dmd.templates.server.generated.dmw.ValueIterableDMW;
import org.dmd.templates.server.util.StaticAccessInfo;
import org.dmd.templates.shared.generated.dmo.ContainedElementDMO;
import org.dmd.templates.shared.generated.dmo.SectionDMO;
import org.dmd.templates.shared.generated.enums.CardinalityEnum;
import org.dmd.templates.shared.generated.types.Contains;
import org.dmd.templates.shared.generated.types.Value;
import org.dmd.util.FileUpdateManager;
import org.dmd.util.ManagedFileWriter;
import org.dmd.util.codegen.ImportManager;
import org.dmd.util.codegen.Manipulator;
import org.dmd.util.codegen.MemberManager;
import org.dmd.util.exceptions.DebugInfo;

public class Section
extends SectionDMW {
    String fastAddArgVector;
    String fastAddArgs;

    public Section() {
    }

    public Section(SectionDMO dmo, ClassDefinition cd) {
        super(dmo, cd);
    }

    public String getClassImport() {
        return this.getDefinedInTdlModule().getPackage() + ".generated.dmtdl." + this.getName();
    }

    void getSubsectionImportsAndMembers(ImportManager imports, MemberManager members) {
        if (this.getStartsWith() != null) {
            imports.addImport(this.getStartsWith().getClassImport(), "Starts with one of these");
            members.addMember(this.getStartsWith().getName().getNameString(), "_" + this.getStartsWith().getName(), "Starts with a " + this.getStartsWith().getName());
        }
        if (this.getContainsHasValue()) {
            ContainsIterableDMW it = this.getContainsIterable();
            while (it.hasNext()) {
                Contains c = (Contains)it.getNext();
                ContainedElement ce = (ContainedElement)((ContainedElementDMO)c.getElement().getObject()).getContainer();
                if (ce instanceof Section) {
                    Section contained = (Section)ce;
                    imports.addImport(contained.getClassImport(), "Is a contained section");
                    if (c.getOccurences() == CardinalityEnum.ONE) {
                        members.addMember(contained.getName().getNameString(), "_" + contained.getName(), "A single instance of " + contained.getName());
                        continue;
                    }
                    if (c.getOccurences() == CardinalityEnum.MANY) {
                        imports.addImport("java.util.ArrayList", "Because we have multiple instances of some Sections");
                        imports.addImport("java.util.Iterator", "Because we have multiple instances of some Sections");
                        members.addMember("ArrayList<" + contained.getName().getNameString() + ">", "_" + contained.getName(), "new ArrayList<" + contained.getName().getNameString() + ">()", "Multiple instances of " + contained.getName());
                        continue;
                    }
                    members.addMember(contained.getName().getNameString(), "_" + contained.getName(), "A single static instance of " + contained.getName());
                    continue;
                }
                ExtensionHook hook = (ExtensionHook)ce;
                hook.getSectionImportsAndMembers(imports, members);
            }
        }
        if (this.getEndsWith() != null) {
            imports.addImport(this.getEndsWith().getClassImport(), "Ends with one of these");
            members.addMember(this.getEndsWith().getName().getNameString(), "_" + this.getEndsWith().getName(), "Ends with a " + this.getEndsWith().getName());
        }
    }

    public void generateSectionClass(String outdir) throws IOException {
        ImportManager imports = new ImportManager();
        MemberManager members = new MemberManager();
        imports.addImport("org.dmd.templates.server.util.SectionIF", "Standard interface used by Templates");
        imports.addImport("org.dmd.templates.server.extended.Template", "The Template");
        imports.addImport("org.dmd.templates.server.util.FormattedArtifactIF", "Common interface for gathering formatted output");
        imports.addImport("java.io.IOException", "Thrown by formatting");
        if (this.getDefinedInTdlModule().getCommentFormat() != null && this.getStartsWithText() != null) {
            imports.addImport("org.dmd.templates.server.util.TemplateMediator", "To access commentContainer");
        }
        if (this.getValueHasValue()) {
            imports.addImport("java.util.TreeMap", "To store values");
            members.addMember("TreeMap<String,String>", "values", "new TreeMap<String,String>()", "Required to store our values");
        }
        ManagedFileWriter out = FileUpdateManager.instance().getWriter(outdir, this.getName().getNameString() + ".java");
        out.write("package " + this.getDefinedInTdlModule().getPackage() + ".generated.dmtdl;\n\n");
        this.getSubsectionImportsAndMembers(imports, members);
        out.write(imports.getFormattedImports() + "\n\n");
        out.write("// Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("public class " + this.getName() + " implements SectionIF {\n\n");
        out.write("\n");
        out.write(members.getFormattedMembers() + "\n");
        out.write("\n");
        out.write("    public " + this.getName() + "(){\n");
        out.write(this.getStaticSectionConstruction());
        out.write("    }\n\n");
        out.write("");
        if (this.getValueHasValue()) {
            Value value;
            ValueIterableDMW values = null;
            if (this.getValueSize() <= this.getDefinedInTdlModule().getMaxFastAddValues()) {
                out.write("    /**\n");
                out.write("     * Constructs a new " + this.getName() + " section.\n");
                values = this.getValueIterable();
                while (values.hasNext()) {
                    value = (Value)values.getNext();
                    out.write("     * @param " + value.getValueName() + "_ " + value.getDescription() + "\n");
                }
                out.write("     * Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
                out.write("     */\n");
                out.write("    public " + this.getName() + "(");
                values = this.getValueIterable();
                while (values.hasNext()) {
                    value = (Value)values.getNext();
                    out.write("String " + value.getValueName() + "_");
                    if (!values.hasNext()) continue;
                    out.write(", ");
                }
                out.write("){\n");
                out.write(this.getStaticSectionConstruction());
                values = this.getValueIterable();
                while (values.hasNext()) {
                    value = (Value)values.getNext();
                    out.write("        if (" + value.getValueName() + "_ != null)\n");
                    out.write("            values.put(\"" + value.getValueName() + "\", " + value.getValueName() + "_);\n");
                    out.write("\n");
                }
                out.write("    }\n\n");
                out.write("");
            }
            values = this.getValueIterable();
            while (values.hasNext()) {
                value = (Value)values.getNext();
                String fn = "set" + Manipulator.capFirstChar(value.getValueName());
                out.write("    public " + this.getName() + " " + fn + "(String " + value.getValueName() + "_){\n");
                out.write("        if (" + value.getValueName() + "_ != null)\n");
                out.write("            values.put(\"" + value.getValueName() + "\", " + value.getValueName() + "_);\n");
                out.write("        return(this);\n");
                out.write("    }\n\n");
            }
            out.write("    public String getValue(String name){\n");
            out.write("        String rc = values.get(name);\n");
            out.write("        if (rc == null)\n");
            out.write("            rc = \"\";\n");
            out.write("        return(rc);\n");
            out.write("    }\n\n");
        } else {
            out.write("    public String getValue(String name){\n");
            out.write("        return(\"\");\n");
            out.write("    }\n\n");
        }
        out.write(this.getFormatFunction());
        if (this.getStartsWith() != null) {
            out.write(this.getStartsWith().getAccessFunctions(this.getName().getNameString(), CardinalityEnum.STATIC, true));
        }
        ContainsIterableDMW it = this.getContainsIterable();
        while (it.hasNext()) {
            Contains c = (Contains)it.getNext();
            ContainedElement ce = (ContainedElement)((ContainedElementDMO)c.getElement().getObject()).getContainer();
            if (ce instanceof Section) {
                Section contained = (Section)ce;
                out.write(contained.getAccessFunctions(this.getName().getNameString(), c.getOccurences(), true));
                continue;
            }
            if (!(ce instanceof ExtensionHook)) continue;
            ExtensionHook hook = (ExtensionHook)ce;
            out.write(hook.getExtensionFunction());
        }
        if (this.getEndsWith() != null) {
            out.write(this.getEndsWith().getAccessFunctions(this.getName().getNameString(), CardinalityEnum.STATIC, true));
        }
        out.write("}");
        ((BufferedWriter)out).close();
    }

    String getStaticSectionConstruction() {
        StringBuffer sb = new StringBuffer();
        if (this.getStartsWith() != null) {
            sb.append("        _" + this.getStartsWith().getName() + " = new " + this.getStartsWith().getName() + "(); // Starts with\n");
        }
        ContainsIterableDMW it = this.getContainsIterable();
        while (it.hasNext()) {
            Contains c = (Contains)it.getNext();
            ContainedElement ce = (ContainedElement)((ContainedElementDMO)c.getElement().getObject()).getContainer();
            if (!(ce instanceof Section)) continue;
            Section contained = (Section)ce;
            if (c.getOccurences() != CardinalityEnum.STATIC) continue;
            sb.append("        _" + contained.getName() + " = new " + contained.getName() + "(); // Static Section\n");
        }
        if (this.getEndsWith() != null) {
            sb.append("        _" + this.getEndsWith().getName() + " = new " + this.getEndsWith().getName() + "(); // Ends with\n");
        }
        return sb.toString();
    }

    String getFormatFunction() {
        StringBuffer sb = new StringBuffer();
        sb.append("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        sb.append("    public void format(FormattedArtifactIF artifact) throws IOException {\n");
        if (this.getStartsWith() != null) {
            sb.append("        _" + this.getStartsWith().getName() + ".format(artifact);\n");
        }
        String loader = Manipulator.capFirstChar(this.getDefinedInTdlModule().getName().getNameString()) + "TemplateLoader";
        if (this.getStartsWithText() != null) {
            if (this.getDefinedInTdlModule().getCommentFormat() != null) {
                sb.append("        TemplateMediator.commentContainer.setValue(\"comment\", \"" + this.getName() + " starts with text\");\n");
                sb.append("        " + loader + "._Comment.format(TemplateMediator.commentContainer, artifact);\n");
            }
            sb.append("        artifact.addText(\"" + this.getStartsWithText().replaceAll("\\\"", "\\\\\"") + "\\n\");\n");
        }
        String comment = "";
        if (this.getDefinedInTdlModule().getCommentFormat() != null) {
            comment = ", " + loader + "._Comment";
        }
        sb.append("\n");
        sb.append("        " + loader + "." + this.getName() + ".format(this,artifact" + comment + ");\n");
        ContainsIterableDMW it = this.getContainsIterable();
        while (it.hasNext()) {
            Contains c = (Contains)it.getNext();
            ContainedElement ce = (ContainedElement)((ContainedElementDMO)c.getElement().getObject()).getContainer();
            if (ce instanceof Section) {
                Section contained = (Section)ce;
                sb.append("\n");
                if (c.getOccurences() == CardinalityEnum.ONE) {
                    sb.append("        if (_" + contained.getName() + " != null)\n");
                    sb.append("            _" + contained.getName() + ".format(artifact);\n");
                    continue;
                }
                if (c.getOccurences() == CardinalityEnum.MANY) {
                    sb.append("        if (_" + contained.getName() + " != null){\n");
                    sb.append("            for(" + contained.getName() + " entry: _" + contained.getName() + "){\n");
                    sb.append("                entry.format(artifact);\n");
                    sb.append("            }\n");
                    sb.append("        }\n");
                    continue;
                }
                sb.append("        _" + contained.getName() + ".format(artifact);\n");
                continue;
            }
            ExtensionHook hook = (ExtensionHook)ce;
            sb.append(hook.getFormatFunction());
        }
        sb.append("\n");
        if (this.getEndsWith() != null) {
            sb.append("        _" + this.getEndsWith().getName() + ".format(artifact);\n");
        }
        if (this.getEndsWithText() != null) {
            sb.append("        artifact.addText(\"" + this.getEndsWithText().replaceAll("\\\"", "\\\\\"") + "\\n\");\n");
        }
        sb.append("    }\n\n");
        sb.append("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        sb.append("    public void format(FormattedArtifactIF artifact, Template template) throws IOException {\n");
        sb.append("        template.format(this, artifact);\n");
        sb.append("    }\n\n");
        return sb.toString();
    }

    String getAccessFunctions(String container, CardinalityEnum cardinality, boolean staticFunctions) {
        StringBuffer sb = new StringBuffer();
        if (cardinality == CardinalityEnum.ONE) {
            sb.append("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    public " + this.getName() + " add" + this.getName() + "(){\n");
            sb.append("        if (_" + this.getName() + " != null)\n");
            sb.append("            throw(new IllegalStateException(\"Multiple calls to add a " + this.getName() + " Section. There should only be one of these in a " + container + ".\"));\n");
            sb.append("        _" + this.getName() + " = new " + this.getName() + "();\n");
            sb.append("        return(_" + this.getName() + ");\n");
            sb.append("    }\n\n");
            sb.append("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    public " + this.getName() + " get" + this.getName() + "(){\n");
            sb.append("        if (_" + this.getName() + " == null)\n");
            sb.append("            throw new IllegalStateException(\"The " + this.getName() + " Section is optional. You must add the section before you get it.\");\n");
            sb.append("\n");
            sb.append("        return(_" + this.getName() + ");\n");
            sb.append("    }\n\n");
            if (this.getValueHasValue() && this.getValueSize() <= this.getDefinedInTdlModule().getMaxFastAddValues()) {
                sb.append("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
                sb.append("    public " + this.getName() + " fastAdd" + this.getName() + "(" + this.getFastAddArgVector() + "){\n");
                sb.append("        if (_" + this.getName() + " != null)\n");
                sb.append("            throw(new IllegalStateException(\"Multiple calls to add a " + this.getName() + " Section. There should only be one of these in a " + container + ".\"));\n");
                sb.append("        _" + this.getName() + " = new " + this.getName() + "(" + this.getFastAddArgs() + ");\n");
                sb.append("        return(_" + this.getName() + ");\n");
                sb.append("    }\n\n");
            }
        } else if (cardinality == CardinalityEnum.MANY) {
            sb.append("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    public " + this.getName() + " add" + this.getName() + "(){\n");
            sb.append("        if (_" + this.getName() + " == null)\n");
            sb.append("            _" + this.getName() + " = new ArrayList<" + this.getName() + ">();\n");
            sb.append("        " + this.getName() + " rc = new " + this.getName() + "();\n");
            sb.append("        _" + this.getName() + ".add(rc);\n");
            sb.append("        return(rc);\n");
            sb.append("    }\n\n");
            sb.append("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
            sb.append("    public Iterator<" + this.getName() + "> get" + this.getName() + "Set(){\n");
            sb.append("        return(_" + this.getName() + ".iterator());\n");
            sb.append("    }\n\n");
            if (this.getValueHasValue() && this.getValueSize() <= this.getDefinedInTdlModule().getMaxFastAddValues()) {
                sb.append("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
                sb.append("    public " + this.getName() + " fastAdd" + this.getName() + "(" + this.getFastAddArgVector() + "){\n");
                sb.append("        if (_" + this.getName() + " == null)\n");
                sb.append("            _" + this.getName() + " = new ArrayList<" + this.getName() + ">();\n");
                sb.append("        " + this.getName() + " rc = new " + this.getName() + "(" + this.getFastAddArgs() + ");\n");
                sb.append("        _" + this.getName() + ".add(rc);\n");
                sb.append("        return(rc);\n");
                sb.append("    }\n\n");
            }
        } else if (staticFunctions) {
            sb.append("    public " + this.getName() + " get" + this.getName() + "(){\n");
            sb.append("        return(_" + this.getName() + ");\n");
            sb.append("    }\n\n");
        }
        return sb.toString();
    }

    public String getFastAddArgVector() {
        if (this.fastAddArgVector == null) {
            if (this.getValueSize() == 0) {
                this.fastAddArgVector = "";
            } else {
                StringBuffer sb = new StringBuffer();
                ValueIterableDMW values = this.getValueIterable();
                while (values.hasNext()) {
                    Value value = (Value)values.getNext();
                    sb.append("String " + value.getValueName() + "_");
                    if (!values.hasNext()) continue;
                    sb.append(", ");
                }
                this.fastAddArgVector = sb.toString();
            }
        }
        return this.fastAddArgVector;
    }

    public String getFastAddArgs() {
        if (this.fastAddArgs == null) {
            if (this.getValueSize() == 0) {
                this.fastAddArgs = "";
            } else {
                StringBuffer sb = new StringBuffer();
                ValueIterableDMW values = this.getValueIterable();
                while (values.hasNext()) {
                    Value value = (Value)values.getNext();
                    sb.append(value.getValueName() + "_");
                    if (!values.hasNext()) continue;
                    sb.append(", ");
                }
                this.fastAddArgs = sb.toString();
            }
        }
        return this.fastAddArgs;
    }

    public void getFormatHint(CardinalityEnum cardinality, String indent, StringBuffer hint) {
        hint.append("     * " + indent);
        switch (cardinality) {
            case MANY: {
                hint.append("[] ");
                break;
            }
            case ONE: {
                hint.append("++ ");
                break;
            }
            case STATIC: {
                hint.append("-- ");
            }
        }
        String values = "";
        if (this.getValueHasValue()) {
            values = "<-";
        }
        hint.append(this.getName().getNameString() + "  " + values + "\n");
        if (this.getStartsWith() != null) {
            this.getStartsWith().getFormatHint(CardinalityEnum.STATIC, indent + "  ", hint);
        }
        ContainsIterableDMW it = this.getContainsIterable();
        while (it.hasNext()) {
            Contains c = (Contains)it.getNext();
            ContainedElement ce = (ContainedElement)((ContainedElementDMO)c.getElement().getObject()).getContainer();
            if (ce instanceof Section) {
                Section contained = (Section)ce;
                contained.getFormatHint(c.getOccurences(), indent + "  ", hint);
                continue;
            }
            if (!(ce instanceof ExtensionHook)) continue;
            ExtensionHook hook = (ExtensionHook)ce;
            hook.getFormatHint(indent + "  ", hint);
        }
        if (this.getEndsWith() != null) {
            this.getEndsWith().getFormatHint(CardinalityEnum.STATIC, indent + "  ", hint);
        }
    }

    void getStaticAccessToStructure(int depth, CardinalityEnum cardinality, String callStructure, TreeMap<String, StaticAccessInfo> sections) {
        if (cardinality == CardinalityEnum.STATIC) {
            if (this.getValueHasValue()) {
                StaticAccessInfo info = sections.get(this.getName().getNameString());
                if (info == null) {
                    info = new StaticAccessInfo(this);
                    sections.put(this.getName().getNameString(), info);
                }
                if (depth == 0) {
                    info.addPath("_" + this.getName());
                } else {
                    info.addPath(callStructure + ".get" + this.getName() + "()");
                }
            }
            if (this.getStartsWith() != null) {
                if (depth == 0) {
                    this.getStartsWith().getStaticAccessToStructure(depth + 1, CardinalityEnum.STATIC, "_" + this.getName(), sections);
                } else {
                    this.getStartsWith().getStaticAccessToStructure(depth + 1, CardinalityEnum.STATIC, callStructure + ".get" + this.getName() + "()", sections);
                }
            }
            boolean nonStaticDirectlyBelowMe = false;
            ContainsIterableDMW it = this.getContainsIterable();
            while (it.hasNext()) {
                Contains c = (Contains)it.getNext();
                ContainedElement ce = (ContainedElement)((ContainedElementDMO)c.getElement().getObject()).getContainer();
                if (!(ce instanceof Section)) continue;
                Section contained = (Section)ce;
                if (depth == 0) {
                    contained.getStaticAccessToStructure(depth + 1, c.getOccurences(), "_" + this.getName(), sections);
                } else {
                    contained.getStaticAccessToStructure(depth + 1, c.getOccurences(), callStructure + ".get" + this.getName() + "()", sections);
                }
                if (c.getOccurences() == CardinalityEnum.STATIC) continue;
                nonStaticDirectlyBelowMe = true;
            }
            if (nonStaticDirectlyBelowMe) {
                StaticAccessInfo info = sections.get(this.getName().getNameString());
                if (info == null) {
                    info = new StaticAccessInfo(this);
                    sections.put(this.getName().getNameString(), info);
                }
                if (depth == 0) {
                    info.addPath("_" + this.getName());
                } else {
                    info.addPath(callStructure + ".get" + this.getName() + "()");
                }
            }
            if (this.getEndsWith() != null) {
                if (depth == 0) {
                    this.getEndsWith().getStaticAccessToStructure(depth + 1, CardinalityEnum.STATIC, "_" + this.getName(), sections);
                } else {
                    this.getEndsWith().getStaticAccessToStructure(depth + 1, CardinalityEnum.STATIC, callStructure + ".get" + this.getName() + "()", sections);
                }
            }
        }
    }
}

