/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.templates.server.extended;

import java.io.IOException;
import java.util.ArrayList;
import org.dmd.dms.ClassDefinition;
import org.dmd.templates.server.generated.dmw.TemplateDMW;
import org.dmd.templates.server.util.FormattedArtifactIF;
import org.dmd.templates.server.util.ValueContainerIF;
import org.dmd.templates.shared.generated.dmo.TemplateDMO;
import org.dmd.util.exceptions.ResultException;

public class Template
extends TemplateDMW {
    ArrayList<Element> elements;

    public Template() {
    }

    public Template(TemplateDMO dmo, ClassDefinition cd) {
        super(dmo, cd);
    }

    public void format(ValueContainerIF section, FormattedArtifactIF artifact) throws IOException {
        if (this.elements == null) {
            throw new IllegalStateException("The Template has not been initialized yet!");
        }
        for (Element element : this.elements) {
            if (element.valueName == null) {
                artifact.addText(element.text);
                continue;
            }
            artifact.addText(section.getValue(element.valueName));
        }
        if (this.elements.size() > 0) {
            artifact.addText("\n");
        }
    }

    public void initialize(String insertMarker) throws ResultException {
        int IMpos;
        int ML = insertMarker.length();
        this.elements = new ArrayList();
        if (this.getFormat() == null) {
            throw new IllegalStateException("A Template should never have a null format");
        }
        String format = this.getFormat().replaceAll("\\\\n", "\\\n");
        boolean wantIM = false;
        int IMstart = 0;
        int textPOS = 0;
        int i = 0;
        while (i < format.length() && (IMpos = format.indexOf(insertMarker, i)) != -1) {
            if (wantIM) {
                this.elements.add(new Element(null, format.substring(IMstart + ML, IMpos).trim()));
                textPOS = IMpos + ML;
                i = IMpos + ML;
                wantIM = false;
                continue;
            }
            IMstart = IMpos;
            wantIM = true;
            if (textPOS < IMstart) {
                this.elements.add(new Element(format.substring(textPOS, IMstart), null));
            }
            i = IMstart + ML;
        }
        if (wantIM) {
            ResultException ex = new ResultException("Unmatched insert marker: " + insertMarker + "" + this.showErrorLocation(IMstart, format));
            ex.setLocationInfo(this.getFile(), this.getLineNumber());
            throw ex;
        }
        if (textPOS < format.length()) {
            this.elements.add(new Element(format.substring(textPOS), null));
        }
    }

    public String getElement(int i) {
        if (this.elements == null) {
            throw new IllegalStateException("The Template has not been initialized yet!");
        }
        if (i < this.elements.size()) {
            Element e = this.elements.get(i);
            if (e.text == null) {
                return e.valueName;
            }
            return e.text;
        }
        return null;
    }

    public int getElementCount() {
        if (this.elements == null) {
            throw new IllegalStateException("The Template has not been initialized yet!");
        }
        return this.elements.size();
    }

    private String showErrorLocation(int position, String input) {
        StringBuffer sb = new StringBuffer("\n" + input + "\n");
        for (int i = 0; i < position; ++i) {
            sb.append(" ");
        }
        sb.append("^");
        return sb.toString();
    }

    class Element {
        String text;
        String valueName;

        Element(String t, String v) {
            if (t != null) {
                this.text = t;
            }
            this.valueName = v;
        }
    }
}

