/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.templates.server.extended;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.TreeMap;
import org.dmd.dms.ClassDefinition;
import org.dmd.templates.server.extended.ContainedElement;
import org.dmd.templates.server.extended.Section;
import org.dmd.templates.server.generated.dmw.ContainsIterableDMW;
import org.dmd.templates.server.generated.dmw.TextualArtifactDMW;
import org.dmd.templates.server.util.StaticAccessInfo;
import org.dmd.templates.shared.generated.dmo.ContainedElementDMO;
import org.dmd.templates.shared.generated.dmo.TextualArtifactDMO;
import org.dmd.templates.shared.generated.enums.CardinalityEnum;
import org.dmd.templates.shared.generated.types.Contains;
import org.dmd.util.FileUpdateManager;
import org.dmd.util.ManagedFileWriter;
import org.dmd.util.codegen.ImportManager;
import org.dmd.util.codegen.MemberManager;
import org.dmd.util.exceptions.DebugInfo;

public class TextualArtifact
extends TextualArtifactDMW {
    public TextualArtifact() {
    }

    public TextualArtifact(TextualArtifactDMO dmo, ClassDefinition cd) {
        super(dmo, cd);
    }

    public void generateTextualArtifactClass(String outdir) throws IOException {
        ImportManager imports = new ImportManager();
        MemberManager members = new MemberManager();
        TreeMap<String, StaticAccessInfo> staticSections = new TreeMap<String, StaticAccessInfo>();
        this.getStaticAccessToStructure(staticSections);
        imports.addImport("org.dmd.templates.server.util.FormattedArtifactIF", "Common interface for gathering formatted output");
        imports.addImport("java.io.IOException", "Thrown by formatting");
        for (StaticAccessInfo info : staticSections.values()) {
            imports.addImport(info.getClassImport(), "To access static Section: " + info.getName());
        }
        ContainsIterableDMW it = this.getContainsIterable();
        while (it.hasNext()) {
            Contains c = (Contains)it.getNext();
            ContainedElement ce = (ContainedElement)((ContainedElementDMO)c.getElement().getObject()).getContainer();
            if (!(ce instanceof Section)) continue;
            Section contained = (Section)ce;
            imports.addImport(contained.getClassImport(), "Is a contained section");
            if (c.getOccurences() == CardinalityEnum.ONE) {
                members.addMember(contained.getName().getNameString(), "_" + contained.getName(), "A single instance of " + contained.getName());
                continue;
            }
            if (c.getOccurences() == CardinalityEnum.MANY) {
                imports.addImport("java.util.ArrayList", "Because we have multiple instances of some Sections");
                imports.addImport("java.util.Iterator", "Because we have multiple instances of some Sections");
                members.addMember("ArrayList<" + contained.getName().getNameString() + ">", "_" + contained.getName(), "new ArrayList<" + contained.getName().getNameString() + ">()", "Multiple instances of " + contained.getName());
                continue;
            }
            members.addMember(contained.getName().getNameString(), "_" + contained.getName(), "A single static instance of " + contained.getName());
        }
        ManagedFileWriter out = FileUpdateManager.instance().getWriter(outdir, this.getName().getNameString() + ".java");
        out.write("package " + this.getDefinedInTdlModule().getPackage() + ".generated.dmtdl;\n\n");
        out.write(imports.getFormattedImports() + "\n\n");
        out.write("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write(this.getFormatHint());
        out.write("    public class " + this.getName() + " {\n\n");
        out.write("\n");
        out.write(members.getFormattedMembers() + "\n");
        out.write("\n");
        out.write("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("    public " + this.getName() + "(){\n");
        out.write(this.getStaticSectionConstruction());
        out.write("    }\n\n");
        out.write("");
        out.write(this.getFormatFunction());
        it = this.getContainsIterable();
        while (it.hasNext()) {
            Contains c = (Contains)it.getNext();
            ContainedElement ce = (ContainedElement)((ContainedElementDMO)c.getElement().getObject()).getContainer();
            if (!(ce instanceof Section)) continue;
            Section contained = (Section)ce;
            out.write(contained.getAccessFunctions(this.getName().getNameString(), c.getOccurences(), false));
        }
        for (StaticAccessInfo info : staticSections.values()) {
            out.write(info.getAccessFunctions());
        }
        out.write("}");
        ((BufferedWriter)out).close();
    }

    String getStaticSectionConstruction() {
        StringBuffer sb = new StringBuffer();
        ContainsIterableDMW it = this.getContainsIterable();
        while (it.hasNext()) {
            Contains c = (Contains)it.getNext();
            ContainedElement ce = (ContainedElement)((ContainedElementDMO)c.getElement().getObject()).getContainer();
            if (!(ce instanceof Section)) continue;
            Section contained = (Section)ce;
            if (c.getOccurences() != CardinalityEnum.STATIC) continue;
            sb.append("        _" + contained.getName() + " = new " + contained.getName() + "(); // Static Section\n");
        }
        return sb.toString();
    }

    String getFormatFunction() {
        StringBuffer sb = new StringBuffer();
        sb.append("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        sb.append("    public void format(FormattedArtifactIF artifact) throws IOException {\n");
        ContainsIterableDMW it = this.getContainsIterable();
        while (it.hasNext()) {
            Contains c = (Contains)it.getNext();
            ContainedElement ce = (ContainedElement)((ContainedElementDMO)c.getElement().getObject()).getContainer();
            if (!(ce instanceof Section)) continue;
            Section contained = (Section)ce;
            sb.append("\n");
            if (c.getOccurences() == CardinalityEnum.ONE) {
                sb.append("        if (_" + contained.getName() + " != null)\n");
                sb.append("            _" + contained.getName() + ".format(artifact);\n");
                continue;
            }
            if (c.getOccurences() == CardinalityEnum.MANY) {
                sb.append("        if (_" + contained.getName() + " != null){\n");
                sb.append("            for(" + contained.getName() + " entry: _" + contained.getName() + "){\n");
                sb.append("                entry.format(artifact);\n");
                sb.append("            }\n");
                sb.append("        }\n");
                continue;
            }
            sb.append("        _" + contained.getName() + ".format(artifact);\n");
        }
        sb.append("\n");
        sb.append("    }\n\n");
        return sb.toString();
    }

    String getFormatHint() {
        StringBuffer hint = new StringBuffer();
        hint.append("    /**\n");
        hint.append("     * The structure of the " + this.getName() + " TextualArtifact is as follows:\n");
        hint.append("     * \n");
        hint.append("     * [] : many Sections\n");
        hint.append("     * ++ : an optional Section\n");
        hint.append("     * -- : a static Section\n");
        hint.append("     * <- : values can be inserted\n");
        hint.append("     * xx : extension hook can be inserted\n");
        hint.append("     * \n");
        hint.append("     * " + this.getName() + "\n");
        ContainsIterableDMW it = this.getContainsIterable();
        while (it.hasNext()) {
            Contains c = (Contains)it.getNext();
            ContainedElement ce = (ContainedElement)((ContainedElementDMO)c.getElement().getObject()).getContainer();
            if (!(ce instanceof Section)) continue;
            Section contained = (Section)ce;
            contained.getFormatHint(c.getOccurences(), "  ", hint);
        }
        hint.append("     */\n");
        return hint.toString();
    }

    void getStaticAccessToStructure(TreeMap<String, StaticAccessInfo> sections) {
        ContainsIterableDMW it = this.getContainsIterable();
        while (it.hasNext()) {
            Contains c = (Contains)it.getNext();
            ContainedElement ce = (ContainedElement)((ContainedElementDMO)c.getElement().getObject()).getContainer();
            if (!(ce instanceof Section)) continue;
            Section contained = (Section)ce;
            contained.getStaticAccessToStructure(0, c.getOccurences(), "", sections);
        }
    }
}

