/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.templates.server.generated.dsd;

import java.util.Collection;
import java.util.Iterator;
import java.util.TreeMap;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcClassInfo;
import org.dmd.dmc.DmcNameClashException;
import org.dmd.dmc.DmcNameClashObjectSet;
import org.dmd.dmc.DmcNameClashResolverIF;
import org.dmd.dmc.DmcNameResolverWithClashSupportIF;
import org.dmd.dmc.DmcNamedObjectIF;
import org.dmd.dmc.DmcObject;
import org.dmd.dmc.DmcObjectName;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.DmcValueExceptionSet;
import org.dmd.dmc.definitions.DmcDefinitionSet;
import org.dmd.dmc.types.DotName;
import org.dmd.dms.DSDefinition;
import org.dmd.dmw.DmwNamedObjectWrapper;
import org.dmd.templates.server.extended.ContainedElement;
import org.dmd.templates.server.extended.ExtensionHook;
import org.dmd.templates.server.extended.Section;
import org.dmd.templates.server.extended.TdlDefinition;
import org.dmd.templates.server.extended.TdlModule;
import org.dmd.templates.server.extended.TextualArtifact;
import org.dmd.templates.server.generated.dsd.TdlModuleDefinitionsIF;
import org.dmd.templates.server.generated.dsd.TdlModuleGlobalInterface;
import org.dmd.templates.shared.generated.dmo.DmtdlDMSAG;
import org.dmd.util.exceptions.ResultException;

public class TdlModuleDefinitionManager
implements DmcNameClashResolverIF,
DmcNameResolverWithClashSupportIF,
TdlModuleGlobalInterface,
TdlModuleDefinitionsIF {
    private DmcDefinitionSet<DSDefinition> allDefinitions = new DmcDefinitionSet("allDefinitions");
    private DmcDefinitionSet<TdlDefinition> TdlDefinitionDefs;
    private DmcDefinitionSet<ContainedElement> ContainedElementDefs;
    private DmcDefinitionSet<ExtensionHook> ExtensionHookDefs;
    private DmcDefinitionSet<Section> SectionDefs;
    private DmcDefinitionSet<TdlModule> TdlModuleDefs;
    private DmcDefinitionSet<TextualArtifact> TextualArtifactDefs;
    private TreeMap<DmcClassInfo, DmcDefinitionSet<?>> indicesByClass = new TreeMap();

    public TdlModuleDefinitionManager() {
        this.TdlDefinitionDefs = new DmcDefinitionSet("TdlDefinition", this.allDefinitions);
        this.indicesByClass.put(DmtdlDMSAG.__TdlDefinition, this.TdlDefinitionDefs);
        this.ContainedElementDefs = new DmcDefinitionSet("ContainedElement", this.allDefinitions, this.TdlDefinitionDefs);
        this.indicesByClass.put(DmtdlDMSAG.__ContainedElement, this.ContainedElementDefs);
        this.SectionDefs = new DmcDefinitionSet("Section", this.allDefinitions, this.ContainedElementDefs);
        this.indicesByClass.put(DmtdlDMSAG.__Section, this.SectionDefs);
        this.ExtensionHookDefs = new DmcDefinitionSet("ExtensionHook", this.allDefinitions, this.ContainedElementDefs);
        this.indicesByClass.put(DmtdlDMSAG.__ExtensionHook, this.ExtensionHookDefs);
        this.TextualArtifactDefs = new DmcDefinitionSet("TextualArtifact", this.allDefinitions, this.TdlDefinitionDefs);
        this.indicesByClass.put(DmtdlDMSAG.__TextualArtifact, this.TextualArtifactDefs);
        this.TdlModuleDefs = new DmcDefinitionSet("TdlModule", this.allDefinitions, this.TdlDefinitionDefs);
        this.indicesByClass.put(DmtdlDMSAG.__TdlModule, this.TdlModuleDefs);
    }

    public void resolveReferences() throws DmcValueExceptionSet {
        for (DSDefinition def : this.allDefinitions.values()) {
            def.resolveReferences(this, this);
        }
    }

    public Collection<DmwNamedObjectWrapper> getIndex(DmcClassInfo ci) {
        DmcDefinitionSet<?> dds = this.indicesByClass.get(ci);
        if (dds == null) {
            throw new IllegalStateException("No index available for class: " + ci.name);
        }
        return dds.getIndex();
    }

    @Override
    public DmcNamedObjectIF findNamedObject(DmcObjectName name) {
        DSDefinition def = null;
        try {
            def = this.allDefinitions.getDefinition(name.toString());
        }
        catch (DmcNameClashException e) {
            e.printStackTrace();
        }
        catch (DmcValueException e) {
            e.printStackTrace();
        }
        return def;
    }

    public DSDefinition findDefinition(DotName name) {
        return this.allDefinitions.getDefinition(name);
    }

    public void deleteDefinition(DotName name) throws ResultException {
        DSDefinition def = this.allDefinitions.getDefinition(name);
        if (def == null) {
            throw new ResultException("Could not find object to delete: " + name.getNameString());
        }
        DmcDefinitionSet<?> dds = this.indicesByClass.get(def.getConstructionClassInfo());
        dds.delete(name);
        def.youAreDeleted();
        TdlDefinition base = (TdlDefinition)def;
        TdlModule module = base.getDefinedInTdlModule();
        if (def instanceof ExtensionHook) {
            module.deleteExtensionHook((ExtensionHook)def);
        } else if (def instanceof Section) {
            module.deleteSection((Section)def);
        } else if (def instanceof TextualArtifact) {
            module.deleteTextualArtifact((TextualArtifact)def);
        } else if (def instanceof TdlModule) {
            // empty if block
        }
    }

    @Override
    public DmcNamedObjectIF findNamedObject(DmcObjectName name, int attributeID) {
        throw new IllegalStateException("This method is not supported on generated definition managers");
    }

    @Override
    public DmcObject findNamedDMO(DmcObjectName name) {
        DSDefinition def = null;
        try {
            def = this.allDefinitions.getDefinition(name.toString());
        }
        catch (DmcNameClashException e) {
            e.printStackTrace();
        }
        catch (DmcValueException e) {
            e.printStackTrace();
        }
        if (def == null) {
            return null;
        }
        return def.getDMO();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public DmcNamedObjectIF findNamedObjectMayClash(DmcObject object, DmcObjectName name, DmcNameClashResolverIF resolver, DmcAttributeInfo ai) throws DmcValueException {
        void var5_9;
        Object var5_5 = null;
        DotName dn = new DotName(name.getNameString() + "." + ai.type);
        if (name.getNameString().indexOf(".") == -1) {
            try {
                DSDefinition dSDefinition = this.allDefinitions.getDefinitionByNameAndType(dn);
                return var5_9;
            }
            catch (DmcNameClashException e) {
                DmcNamedObjectIF dmcNamedObjectIF = resolver.resolveClash(object, ai, e.getClashSet());
                if (dmcNamedObjectIF != null) return var5_9;
                DmcValueException ex = new DmcValueException("The reference to : " + name.getNameString() + " is ambiguous. You must specify the module name as a prefix to the name. Here are your options:");
                Iterator<DmcNamedObjectIF> it = e.getMatches();
                while (it.hasNext()) {
                    TdlDefinition def = (TdlDefinition)it.next();
                    ex.addMoreInfo(def.getDefinedInTdlModule().getName().getNameString() + "." + name.getNameString());
                }
                throw ex;
            }
        } else {
            DSDefinition dSDefinition = this.allDefinitions.getDefinition(dn);
        }
        return var5_9;
    }

    @Override
    public DmcNamedObjectIF resolveClash(DmcObject obj, DmcAttributeInfo ai, DmcNameClashObjectSet<?> ncos) throws DmcValueException {
        DSDefinition rc = null;
        DSDefinition resolving = (DSDefinition)obj.getContainer();
        Iterator<DmcNamedObjectIF> it = ncos.getMatches();
        while (it.hasNext()) {
            DSDefinition def = (DSDefinition)it.next();
            if (!resolving.getNameOfModuleWhereThisCameFrom().equals(def.getNameOfModuleWhereThisCameFrom())) continue;
            rc = def;
            break;
        }
        return rc;
    }

    void addTdlDefinition(TdlDefinition def) {
        this.TdlDefinitionDefs.add(def);
    }

    void deleteTdlDefinition(TdlDefinition def) {
        try {
            this.TdlDefinitionDefs.delete(def);
        }
        catch (ResultException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public int getTdlDefinitionCount() {
        return this.TdlDefinitionDefs.size();
    }

    @Override
    public TdlDefinition getTdlDefinition(DotName name) {
        return this.TdlDefinitionDefs.getDefinition(name);
    }

    @Override
    public Iterator<TdlDefinition> getAllTdlDefinition() {
        return this.TdlDefinitionDefs.values().iterator();
    }

    @Override
    public void addContainedElement(ContainedElement def) {
        this.ContainedElementDefs.add(def);
        this.addTdlDefinition(def);
    }

    @Override
    public void deleteContainedElement(ContainedElement def) {
        try {
            this.ContainedElementDefs.delete(def);
        }
        catch (ResultException e) {
            throw new IllegalStateException(e);
        }
        this.deleteTdlDefinition(def);
    }

    @Override
    public int getContainedElementCount() {
        return this.ContainedElementDefs.size();
    }

    @Override
    public ContainedElement getContainedElement(DotName name) {
        return this.ContainedElementDefs.getDefinition(name);
    }

    @Override
    public Iterator<ContainedElement> getAllContainedElement() {
        return this.ContainedElementDefs.values().iterator();
    }

    @Override
    public ContainedElement getContainedElementDefinition(String name) throws DmcNameClashException, DmcValueException {
        return this.ContainedElementDefs.getDefinition(name);
    }

    @Override
    public Iterator<ContainedElement> getContainedElementDefinitionsByName(String name) throws DmcValueException {
        return this.ContainedElementDefs.getDefinitionsByName(name);
    }

    @Override
    public int getContainedElementDefinitionCountByName(String name) throws DmcValueException {
        return this.ContainedElementDefs.getDefinitionCountByName(name);
    }

    @Override
    public void addExtensionHook(ExtensionHook def) {
        this.ExtensionHookDefs.add(def);
        this.addContainedElement(def);
    }

    @Override
    public void deleteExtensionHook(ExtensionHook def) {
        try {
            this.ExtensionHookDefs.delete(def);
        }
        catch (ResultException e) {
            throw new IllegalStateException(e);
        }
        this.deleteContainedElement(def);
    }

    @Override
    public int getExtensionHookCount() {
        return this.ExtensionHookDefs.size();
    }

    @Override
    public ExtensionHook getExtensionHook(DotName name) {
        return this.ExtensionHookDefs.getDefinition(name);
    }

    @Override
    public Iterator<ExtensionHook> getAllExtensionHook() {
        return this.ExtensionHookDefs.values().iterator();
    }

    @Override
    public ExtensionHook getExtensionHookDefinition(String name) throws DmcNameClashException, DmcValueException {
        return this.ExtensionHookDefs.getDefinition(name);
    }

    @Override
    public Iterator<ExtensionHook> getExtensionHookDefinitionsByName(String name) throws DmcValueException {
        return this.ExtensionHookDefs.getDefinitionsByName(name);
    }

    @Override
    public int getExtensionHookDefinitionCountByName(String name) throws DmcValueException {
        return this.ExtensionHookDefs.getDefinitionCountByName(name);
    }

    @Override
    public void addSection(Section def) {
        this.SectionDefs.add(def);
        this.addContainedElement(def);
    }

    @Override
    public void deleteSection(Section def) {
        try {
            this.SectionDefs.delete(def);
        }
        catch (ResultException e) {
            throw new IllegalStateException(e);
        }
        this.deleteContainedElement(def);
    }

    @Override
    public int getSectionCount() {
        return this.SectionDefs.size();
    }

    @Override
    public Section getSection(DotName name) {
        return this.SectionDefs.getDefinition(name);
    }

    @Override
    public Iterator<Section> getAllSection() {
        return this.SectionDefs.values().iterator();
    }

    @Override
    public Section getSectionDefinition(String name) throws DmcNameClashException, DmcValueException {
        return this.SectionDefs.getDefinition(name);
    }

    @Override
    public Iterator<Section> getSectionDefinitionsByName(String name) throws DmcValueException {
        return this.SectionDefs.getDefinitionsByName(name);
    }

    @Override
    public int getSectionDefinitionCountByName(String name) throws DmcValueException {
        return this.SectionDefs.getDefinitionCountByName(name);
    }

    @Override
    public void addTdlModule(TdlModule def) {
        this.TdlModuleDefs.add(def);
        this.addTdlDefinition(def);
    }

    @Override
    public void deleteTdlModule(TdlModule def) {
        try {
            this.TdlModuleDefs.delete(def);
        }
        catch (ResultException e) {
            throw new IllegalStateException(e);
        }
        this.deleteTdlDefinition(def);
    }

    @Override
    public int getTdlModuleCount() {
        return this.TdlModuleDefs.size();
    }

    @Override
    public TdlModule getTdlModule(DotName name) {
        return this.TdlModuleDefs.getDefinition(name);
    }

    @Override
    public Iterator<TdlModule> getAllTdlModule() {
        return this.TdlModuleDefs.values().iterator();
    }

    @Override
    public TdlModule getTdlModuleDefinition(String name) throws DmcNameClashException, DmcValueException {
        return this.TdlModuleDefs.getDefinition(name);
    }

    @Override
    public Iterator<TdlModule> getTdlModuleDefinitionsByName(String name) throws DmcValueException {
        return this.TdlModuleDefs.getDefinitionsByName(name);
    }

    @Override
    public int getTdlModuleDefinitionCountByName(String name) throws DmcValueException {
        return this.TdlModuleDefs.getDefinitionCountByName(name);
    }

    @Override
    public void addTextualArtifact(TextualArtifact def) {
        this.TextualArtifactDefs.add(def);
        this.addTdlDefinition(def);
    }

    @Override
    public void deleteTextualArtifact(TextualArtifact def) {
        try {
            this.TextualArtifactDefs.delete(def);
        }
        catch (ResultException e) {
            throw new IllegalStateException(e);
        }
        this.deleteTdlDefinition(def);
    }

    @Override
    public int getTextualArtifactCount() {
        return this.TextualArtifactDefs.size();
    }

    @Override
    public TextualArtifact getTextualArtifact(DotName name) {
        return this.TextualArtifactDefs.getDefinition(name);
    }

    @Override
    public Iterator<TextualArtifact> getAllTextualArtifact() {
        return this.TextualArtifactDefs.values().iterator();
    }

    @Override
    public TextualArtifact getTextualArtifactDefinition(String name) throws DmcNameClashException, DmcValueException {
        return this.TextualArtifactDefs.getDefinition(name);
    }

    @Override
    public Iterator<TextualArtifact> getTextualArtifactDefinitionsByName(String name) throws DmcValueException {
        return this.TextualArtifactDefs.getDefinitionsByName(name);
    }

    @Override
    public int getTextualArtifactDefinitionCountByName(String name) throws DmcValueException {
        return this.TextualArtifactDefs.getDefinitionCountByName(name);
    }

    public void addDefinition(DSDefinition definition) {
        if (definition instanceof ExtensionHook) {
            this.addExtensionHook((ExtensionHook)definition);
        } else if (definition instanceof Section) {
            this.addSection((Section)definition);
        } else if (definition instanceof TextualArtifact) {
            this.addTextualArtifact((TextualArtifact)definition);
        } else if (definition instanceof TdlModule) {
            this.addTdlModule((TdlModule)definition);
        }
    }

    public void addDefinition(DSDefinition definition, TdlModule module) {
        if (definition instanceof ExtensionHook) {
            this.addExtensionHook((ExtensionHook)definition);
            module.addExtensionHook((ExtensionHook)definition);
        } else if (definition instanceof Section) {
            this.addSection((Section)definition);
            module.addSection((Section)definition);
        } else if (definition instanceof TextualArtifact) {
            this.addTextualArtifact((TextualArtifact)definition);
            module.addTextualArtifact((TextualArtifact)definition);
        } else if (definition instanceof TdlModule) {
            this.addTdlModule((TdlModule)definition);
        }
    }

    public String summary() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.TdlDefinitionDefs.summary());
        sb.append(this.ContainedElementDefs.summary());
        sb.append(this.SectionDefs.summary());
        sb.append(this.ExtensionHookDefs.summary());
        sb.append(this.TextualArtifactDefs.summary());
        sb.append(this.TdlModuleDefs.summary());
        return sb.toString();
    }
}

