/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.templates.server.generated.dsd;

import org.dmd.dmc.DmcNameClashException;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.definitions.DsdParserInterface;
import org.dmd.dmc.rules.DmcRuleExceptionSet;
import org.dmd.dmc.rules.SourceInfo;
import org.dmd.dmc.util.DmcUncheckedObject;
import org.dmd.dms.AttributeDefinition;
import org.dmd.dms.MetaSchema;
import org.dmd.dms.SchemaManager;
import org.dmd.dms.generated.dmw.AttributeDefinitionIterableDMW;
import org.dmd.dms.generated.dmw.StringIterableDMW;
import org.dmd.dmv.shared.DmvRuleManager;
import org.dmd.dmw.DmwObjectFactory;
import org.dmd.dmw.DmwWrapper;
import org.dmd.templates.server.extended.ExtensionHook;
import org.dmd.templates.server.extended.Section;
import org.dmd.templates.server.extended.TdlDefinition;
import org.dmd.templates.server.extended.TdlModule;
import org.dmd.templates.server.extended.TextualArtifact;
import org.dmd.templates.server.generated.DmtdlSchemaAG;
import org.dmd.templates.server.generated.dsd.TdlModuleGlobalInterface;
import org.dmd.templates.shared.generated.dmo.DmtdlDMSAG;
import org.dmd.util.exceptions.ResultException;
import org.dmd.util.parsing.ConfigLocation;
import org.dmd.util.parsing.DmcUncheckedOIFHandlerIF;
import org.dmd.util.parsing.DmcUncheckedOIFParser;

public class TdlModuleParser
implements DsdParserInterface,
DmcUncheckedOIFHandlerIF {
    static final String fileExtension = "dmtdl";
    SchemaManager schema;
    DmcUncheckedOIFParser parser = new DmcUncheckedOIFParser(this);
    DmwObjectFactory factory;
    TdlModuleGlobalInterface definitions;
    DmvRuleManager rules;
    ConfigLocation location;
    TdlModule module;

    public TdlModuleParser(TdlModuleGlobalInterface d, DmvRuleManager r) throws ResultException, DmcValueException, DmcNameClashException {
        this.schema = new SchemaManager();
        DmtdlSchemaAG sd = new DmtdlSchemaAG();
        this.schema.manageSchema(sd.getInstance());
        if (sd.getAttributeDefListSize() > 0) {
            this.preserveNewLines(sd.getAttributeDefList());
        }
        this.preserveNewLines(MetaSchema._metaSchema.getAttributeDefList());
        this.factory = new DmwObjectFactory(this.schema);
        this.definitions = d;
        this.rules = r;
        this.rules.loadRules(DmtdlDMSAG.instance());
    }

    public SchemaManager schema() {
        return this.schema;
    }

    void preserveNewLines(AttributeDefinitionIterableDMW attrs) {
        while (attrs.hasNext()) {
            AttributeDefinition ad = (AttributeDefinition)attrs.getNext();
            if (!ad.getPreserveNewlines().booleanValue()) continue;
            this.parser.addPreserveNewlinesAttribute(ad.getName().getNameString());
        }
    }

    @Override
    public String getFileExtension() {
        return fileExtension;
    }

    public TdlModule parseConfig(ConfigLocation l) throws ResultException, DmcValueException, DmcRuleExceptionSet, DmcNameClashException {
        this.location = l;
        this.module = null;
        if (this.location.isFromJAR()) {
            System.out.println("Reading: " + this.location.getFileName() + " - from " + this.location.getJarFilename());
            this.parser.parseFile(this.location.getFileName(), true);
        } else {
            System.out.println("Reading: " + this.location.getFileName());
            this.parser.parseFile(this.location.getFileName());
        }
        if (this.module.getDefFilesHasValue()) {
            StringIterableDMW it = this.module.getDefFilesIterable();
            while (it.hasNext()) {
                String fn = this.location.getDirectory() + "/" + (String)it.next();
                if (this.location.isFromJAR()) {
                    this.parser.parseFile(fn, true);
                    continue;
                }
                this.parser.parseFile(fn);
            }
        }
        return this.module;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handleObject(DmcUncheckedObject uco, String infile, int lineNumber) throws ResultException, DmcValueException, DmcRuleExceptionSet, DmcNameClashException {
        TdlDefinition definition = null;
        DmwWrapper wrapper = null;
        try {
            wrapper = this.factory.createWrapper(uco);
            definition = (TdlDefinition)wrapper;
        }
        catch (ClassNotFoundException e) {
            ResultException ex = new ResultException("Unknown object class: " + uco.classes.get(0));
            ex.result.lastResult().fileName(infile);
            ex.result.lastResult().lineNumber(lineNumber);
            throw ex;
        }
        catch (ResultException ex) {
            ex.setLocationInfo(infile, lineNumber);
            throw ex;
        }
        catch (DmcValueException e) {
            ResultException ex = new ResultException();
            ex.addError(e.getMessage());
            if (e.getAttributeName() != null) {
                ex.result.lastResult().moreMessages("Attribute: " + e.getAttributeName());
            }
            ex.setLocationInfo(infile, lineNumber);
            throw ex;
        }
        catch (ClassCastException e) {
            ResultException ex = new ResultException();
            ex.addError("All classes in your DSL must ultimately be derived from: TdlDefinition");
            ex.addError("The following object is not valid in a .dmtdl file:\n\n" + wrapper.toOIF());
            ex.setLocationInfo(infile, lineNumber);
            throw ex;
        }
        definition.setLineNumber(lineNumber);
        definition.setFile(infile);
        try {
            this.rules.executeInitializers(definition.getDmcObject());
        }
        catch (DmcRuleExceptionSet ex) {
            ex.source(new SourceInfo(infile, lineNumber));
            throw ex;
        }
        if (this.module == null) {
            if (!(definition instanceof TdlModule)) {
                ResultException ex = new ResultException("Expecting a TdlModule module definition");
                ex.setLocationInfo(infile, lineNumber);
                throw ex;
            }
            this.module = (TdlModule)definition;
            int lastSep = infile.lastIndexOf("/");
            int period = infile.lastIndexOf(46);
            String fn = infile.substring(lastSep + 1, period);
            if (this.module.getName() == null) {
                ResultException ex = new ResultException("Missing name attribute for module definition");
                ex.setLocationInfo(infile, lineNumber);
                throw ex;
            }
            if (!this.module.getName().getNameString().equals(fn)) {
                ResultException ex = new ResultException("Module name: " + this.module.getName().getNameString() + " - must match file name: " + fn);
                ex.setLocationInfo(infile, lineNumber);
                throw ex;
            }
            definition.setDotName(this.module.getName() + "." + this.module.getName() + "." + definition.getConstructionClassName());
            this.module.setDefinedInTdlModule(this.module);
            this.definitions.addTdlModule(this.module);
        } else {
            if (definition instanceof TdlModule) {
                ResultException ex = new ResultException("Multiple TdlModule definitions while parsing config: " + this.location.getFileName());
                ex.setLocationInfo(infile, lineNumber);
                throw ex;
            }
            definition.setDefinedInTdlModule(this.module);
            definition.setDmoFromModule(this.module.getName().getNameString());
            definition.setDotName(this.module.getName() + "." + definition.getName() + "." + definition.getConstructionClassName());
            try {
                this.rules.executeObjectValidation(definition.getDmcObject());
            }
            catch (DmcRuleExceptionSet ex) {
                ex.source(new SourceInfo(infile, lineNumber));
                throw ex;
            }
            if (definition instanceof ExtensionHook) {
                this.definitions.addExtensionHook((ExtensionHook)definition);
                this.module.addExtensionHook((ExtensionHook)definition);
            } else if (definition instanceof Section) {
                this.definitions.addSection((Section)definition);
                this.module.addSection((Section)definition);
            } else if (definition instanceof TextualArtifact) {
                this.definitions.addTextualArtifact((TextualArtifact)definition);
                this.module.addTextualArtifact((TextualArtifact)definition);
            }
        }
        try {
            this.rules.executeAttributeValidation(definition.getDmcObject());
            this.rules.executeObjectValidation(definition.getDmcObject());
            return;
        }
        catch (DmcRuleExceptionSet ex) {
            ex.source(new SourceInfo(infile, lineNumber));
            throw ex;
        }
    }
}

