/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.templates.server.generated.dsd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import org.dmd.dmc.DmcNameClashException;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.DmcValueExceptionSet;
import org.dmd.dmc.rules.DmcRuleExceptionSet;
import org.dmd.dmc.types.DefinitionName;
import org.dmd.dms.DSDefinition;
import org.dmd.dmv.shared.DmvRuleManager;
import org.dmd.templates.server.extended.TdlModule;
import org.dmd.templates.server.generated.dsd.TdlModuleDefinitionManager;
import org.dmd.templates.server.generated.dsd.TdlModuleGeneratorInterface;
import org.dmd.templates.server.generated.dsd.TdlModuleParser;
import org.dmd.templates.shared.generated.types.TdlModuleREF;
import org.dmd.util.exceptions.ResultException;
import org.dmd.util.parsing.ConfigFinder;
import org.dmd.util.parsing.ConfigLocation;
import org.dmd.util.parsing.ConfigVersion;

public class TdlModuleParsingCoordinator {
    DmvRuleManager rules = new DmvRuleManager();
    TdlModuleDefinitionManager definitions = new TdlModuleDefinitionManager();
    TdlModuleGeneratorInterface generator;
    TreeMap<String, ModuleInfoBase> loadedConfigs = new TreeMap();
    TdlModuleParser parserForTdlModule;
    ConfigFinder finderForTdlModule = new ConfigFinder(".dmtdl");
    TreeMap<DefinitionName, TdlModuleInfo> loadedTdlModuleConfigs = new TreeMap();

    public TdlModuleParsingCoordinator(TdlModuleGeneratorInterface g, ArrayList<String> sourceDirs, ArrayList<String> jars) throws ResultException, DmcValueException, DmcNameClashException, DmcRuleExceptionSet, IOException {
        this.generator = g;
        this.parserForTdlModule = new TdlModuleParser(this.definitions, this.rules);
        this.finderForTdlModule.setSourceAndJarInfo(sourceDirs, jars);
        this.finderForTdlModule.findConfigs();
    }

    public DmvRuleManager getRuleManager() {
        return this.rules;
    }

    public TdlModuleParser parserForTdlModule() {
        return this.parserForTdlModule;
    }

    public void generateForConfig(String configName) throws ResultException, DmcValueException, DmcRuleExceptionSet, DmcNameClashException, DmcValueExceptionSet, IOException {
        ConfigVersion version = this.finderForTdlModule.getConfig(configName);
        if (version == null) {
            ResultException ex = new ResultException("Could not find the specified configuration file: " + configName);
            throw ex;
        }
        ConfigLocation location = version.getLatestVersion();
        TdlModule loaded = this.loadTdlModuleModule(location);
        if (location.isFromJAR()) {
            ResultException ex = new ResultException("We can't run generation for a config loaded from a JAR: " + configName);
            ex.moreMessages(location.toString());
            throw ex;
        }
        this.generator.parsingComplete(loaded, location, this.definitions);
        this.definitions.resolveReferences();
        this.generator.generate(loaded, location, this.definitions);
    }

    public void generateForAllConfigs() throws ResultException, DmcValueException, DmcRuleExceptionSet, DmcNameClashException, DmcValueExceptionSet, IOException {
        TdlModule loaded = null;
        TdlModuleInfo loadedInfo = null;
        Iterator<ConfigLocation> it = this.finderForTdlModule.getLocations();
        while (it.hasNext()) {
            ConfigLocation location = it.next();
            loadedInfo = (TdlModuleInfo)this.loadedConfigs.get(location.getFileName());
            loaded = loadedInfo == null ? this.loadTdlModuleModule(location) : loadedInfo.module;
            this.generator.parsingComplete(loaded, location, this.definitions);
            this.definitions.resolveReferences();
            this.generator.objectResolutionComplete(loaded, location, this.definitions);
        }
        this.generator.generate(this.definitions);
    }

    TdlModule loadTdlModuleModule(ConfigLocation location) throws ResultException, DmcValueException, DmcRuleExceptionSet, DmcNameClashException {
        TdlModuleInfo info = this.loadedTdlModuleConfigs.get(new DefinitionName(location.getConfigName()));
        if (info != null) {
            return info.module;
        }
        TdlModule loaded = this.parserForTdlModule.parseConfig(location);
        TdlModuleInfo loadedInfo = new TdlModuleInfo(loaded, location);
        this.loadedTdlModuleConfigs.put(loaded.getName(), loadedInfo);
        this.loadedConfigs.put(location.getFileName(), loadedInfo);
        this.loadModuleDependencies(loadedInfo);
        return loaded;
    }

    public ConfigLocation getLocation(TdlModule module) {
        TdlModuleInfo info = this.loadedTdlModuleConfigs.get(module.getName());
        if (info == null) {
            throw new IllegalStateException("Couldn't find ConfigLocation for module: \n\n" + module.toOIF());
        }
        return info.location;
    }

    void loadModuleDependencies(ModuleInfoBase mi) throws ResultException, DmcValueException, DmcRuleExceptionSet, DmcNameClashException {
        if (mi.dependenciesLoaded) {
            return;
        }
        if (mi instanceof TdlModuleInfo) {
            TdlModuleInfo info = (TdlModuleInfo)mi;
            if (info.module.getDependsOnTdlModuleHasValue()) {
                Iterator<TdlModuleREF> it = info.module.getDMO().getDependsOnTdlModule();
                while (it.hasNext()) {
                    TdlModuleREF ref = it.next();
                    ConfigVersion version = this.finderForTdlModule.getConfig(ref.toString());
                    if (version == null) {
                        this.missingConfigError(info.module, ref.toString() + ".dmtdl");
                    }
                    this.loadTdlModuleModule(version.getLatestVersion());
                }
            }
            info.dependenciesLoaded = true;
        }
    }

    void missingConfigError(String missing) throws ResultException {
        ResultException ex = new ResultException("Could not find config: " + missing);
        throw ex;
    }

    void missingConfigError(DSDefinition module, String missing) throws ResultException {
        ResultException ex = new ResultException("Could not find config: " + missing);
        ex.setLocationInfo(module.getFile(), module.getLineNumber());
        throw ex;
    }

    class TdlModuleInfo
    extends ModuleInfoBase {
        TdlModule module;

        TdlModuleInfo(TdlModule m, ConfigLocation l) {
            this.module = m;
            this.location = l;
        }
    }

    class ModuleInfoBase {
        ConfigLocation location;
        boolean dependenciesLoaded;

        ModuleInfoBase() {
        }
    }
}

