/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.templates.server.util;

import java.util.ArrayList;
import org.dmd.templates.server.extended.Section;
import org.dmd.util.codegen.Manipulator;
import org.dmd.util.exceptions.DebugInfo;

public class StaticAccessInfo
implements Comparable<StaticAccessInfo> {
    Section section;
    ArrayList<String> callPaths;

    public StaticAccessInfo(Section s) {
        this.section = s;
        this.callPaths = new ArrayList();
    }

    public String getName() {
        return this.section.getName().getNameString();
    }

    public void addPath(String p) {
        if (!this.callPaths.contains(p)) {
            this.callPaths.add(p);
        }
    }

    @Override
    public int compareTo(StaticAccessInfo info) {
        if (info == null) {
            return 1;
        }
        return this.section.getName().getNameString().compareTo(info.section.getName().getNameString());
    }

    public int hashCode() {
        return this.section.getName().getNameString().hashCode();
    }

    public String getClassImport() {
        return this.section.getClassImport();
    }

    public String getAccessFunctions() {
        StringBuffer sb = new StringBuffer();
        sb.append("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        String sn = Manipulator.capFirstChar(this.section.getName().getNameString());
        if (this.callPaths.size() == 1) {
            sb.append("    /**\n");
            sb.append("     * @return the " + this.section.getName() + " Section at: " + this.callPaths.get(0) + "\n");
            sb.append("     */\n");
            sb.append("    public " + this.section.getName() + " get" + sn + "(){\n");
            sb.append("        return(" + this.callPaths.get(0) + ");\n");
            sb.append("    }\n\n");
        } else {
            String suffix = "";
            for (int i = 0; i < this.callPaths.size(); ++i) {
                int x = i + 1;
                suffix = "" + x;
                sb.append("    /**\n");
                sb.append("     * @return the " + this.section.getName() + " Section at: " + this.callPaths.get(i) + "\n");
                sb.append("     */\n");
                sb.append("    public " + this.section.getName() + " get" + sn + suffix + "(){\n");
                sb.append("        return(" + this.callPaths.get(i) + ");\n");
                sb.append("    }\n\n");
            }
        }
        return sb.toString();
    }
}

