/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.templates.shared.generated.dsd;

import java.util.Iterator;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcNameClashException;
import org.dmd.dmc.DmcNameClashObjectSet;
import org.dmd.dmc.DmcNameClashResolverIF;
import org.dmd.dmc.DmcNameResolverWithClashSupportIF;
import org.dmd.dmc.DmcNamedObjectIF;
import org.dmd.dmc.DmcObject;
import org.dmd.dmc.DmcObjectName;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.DmcValueExceptionSet;
import org.dmd.dmc.definitions.DMODefinitionSet;
import org.dmd.dmc.types.DotName;
import org.dmd.dms.generated.dmo.DSDefinitionDMO;
import org.dmd.dmv.shared.DmvRuleManager;
import org.dmd.templates.shared.generated.dmo.ContainedElementDMO;
import org.dmd.templates.shared.generated.dmo.DmtdlDMSAG;
import org.dmd.templates.shared.generated.dmo.ExtensionHookDMO;
import org.dmd.templates.shared.generated.dmo.SectionDMO;
import org.dmd.templates.shared.generated.dmo.TdlDefinitionDMO;
import org.dmd.templates.shared.generated.dmo.TdlModuleDMO;
import org.dmd.templates.shared.generated.dmo.TextualArtifactDMO;
import org.dmd.templates.shared.generated.dsd.TdlModuleGlobalInterface;

public class TdlModuleDefinitionDMOCache
implements DmcNameClashResolverIF,
DmcNameResolverWithClashSupportIF,
TdlModuleGlobalInterface {
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private DmvRuleManager ruleManager = new DmvRuleManager();
    private DMODefinitionSet<DSDefinitionDMO> allDefinitions;
    private TreeMap<String, DMODefinitionSet<?>> indicesByClass;
    private DMODefinitionSet<TdlDefinitionDMO> TdlDefinitionDefs;
    private DMODefinitionSet<ContainedElementDMO> ContainedElementDefs;
    private DMODefinitionSet<ExtensionHookDMO> ExtensionHookDefs;
    private DMODefinitionSet<SectionDMO> SectionDefs;
    private DMODefinitionSet<TdlModuleDMO> TdlModuleDefs;
    private DMODefinitionSet<TextualArtifactDMO> TextualArtifactDefs;

    public TdlModuleDefinitionDMOCache() {
        this.ruleManager.loadRules(DmtdlDMSAG.instance());
        this.allDefinitions = new DMODefinitionSet("allDefinitions");
        this.indicesByClass = new TreeMap();
        this.TdlDefinitionDefs = new DMODefinitionSet("TdlDefinition", this.allDefinitions);
        this.indicesByClass.put(this.TdlDefinitionDefs.className(), this.TdlDefinitionDefs);
        this.ContainedElementDefs = new DMODefinitionSet("ContainedElement", this.allDefinitions, this.TdlDefinitionDefs);
        this.indicesByClass.put(this.ContainedElementDefs.className(), this.ContainedElementDefs);
        this.SectionDefs = new DMODefinitionSet("Section", this.allDefinitions, this.ContainedElementDefs);
        this.indicesByClass.put(this.SectionDefs.className(), this.SectionDefs);
        this.ExtensionHookDefs = new DMODefinitionSet("ExtensionHook", this.allDefinitions, this.ContainedElementDefs);
        this.indicesByClass.put(this.ExtensionHookDefs.className(), this.ExtensionHookDefs);
        this.TextualArtifactDefs = new DMODefinitionSet("TextualArtifact", this.allDefinitions, this.TdlDefinitionDefs);
        this.indicesByClass.put(this.TextualArtifactDefs.className(), this.TextualArtifactDefs);
        this.TdlModuleDefs = new DMODefinitionSet("TdlModule", this.allDefinitions, this.TdlDefinitionDefs);
        this.indicesByClass.put(this.TdlModuleDefs.className(), this.TdlModuleDefs);
    }

    public DmvRuleManager ruleManager() {
        return this.ruleManager;
    }

    public void resolveReferences() throws DmcValueExceptionSet {
        for (DSDefinitionDMO def : this.allDefinitions.values()) {
            def.resolveReferencesExceptClass(this, this);
        }
    }

    @Override
    public DmcNamedObjectIF findNamedObject(DmcObjectName name) {
        DSDefinitionDMO def = null;
        try {
            def = this.allDefinitions.getDefinition(name.toString());
        }
        catch (DmcNameClashException e) {
            this.logger.fine(e.toString());
        }
        catch (DmcValueException e) {
            this.logger.fine(e.toString());
        }
        return def;
    }

    public DSDefinitionDMO findDefinition(DotName name) {
        return this.allDefinitions.getDefinition(name);
    }

    public void deleteDefinition(DotName name) throws Exception {
        DSDefinitionDMO def = this.allDefinitions.getDefinition(name);
        if (def == null) {
            throw new Exception("Could not find object to delete: " + name.getNameString());
        }
        DMODefinitionSet<?> dds = this.indicesByClass.get(def.getConstructionClassName());
        dds.delete(name);
        def.youAreDeleted();
    }

    @Override
    public DmcNamedObjectIF findNamedObject(DmcObjectName name, int attributeID) {
        throw new IllegalStateException("This method is not supported on generated definition managers");
    }

    @Override
    public DmcObject findNamedDMO(DmcObjectName name) {
        DSDefinitionDMO def = null;
        try {
            def = name instanceof DotName ? this.allDefinitions.getDefinition((DotName)name) : this.allDefinitions.getDefinition(name.toString());
        }
        catch (DmcNameClashException e) {
            this.logger.fine(e.toString());
        }
        catch (DmcValueException e) {
            this.logger.fine(e.toString());
        }
        return def;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public DmcNamedObjectIF findNamedObjectMayClash(DmcObject object, DmcObjectName name, DmcNameClashResolverIF resolver, DmcAttributeInfo ai) throws DmcValueException {
        void var5_9;
        Object var5_5 = null;
        DotName dn = new DotName(name.getNameString() + "." + ai.type);
        if (name.getNameString().indexOf(".") == -1) {
            try {
                DSDefinitionDMO dSDefinitionDMO = this.allDefinitions.getDefinitionByNameAndType(dn);
                return var5_9;
            }
            catch (DmcNameClashException e) {
                DmcNamedObjectIF dmcNamedObjectIF = resolver.resolveClash(object, ai, e.getClashSet());
                if (dmcNamedObjectIF != null) return var5_9;
                DmcValueException ex = new DmcValueException("The reference to : " + name.getNameString() + " is ambiguous. You must specify the module name as a prefix to the name. Here are your options:");
                Iterator<DmcNamedObjectIF> it = e.getMatches();
                while (it.hasNext()) {
                    TdlDefinitionDMO def = (TdlDefinitionDMO)it.next();
                    ex.addMoreInfo(def.getDefinedInTdlModule().getName().getNameString() + "." + name.getNameString());
                }
                throw ex;
            }
        } else {
            DSDefinitionDMO dSDefinitionDMO = this.allDefinitions.getDefinition(dn);
        }
        return var5_9;
    }

    @Override
    public DmcNamedObjectIF resolveClash(DmcObject obj, DmcAttributeInfo ai, DmcNameClashObjectSet<?> ncos) throws DmcValueException {
        DSDefinitionDMO rc = null;
        DSDefinitionDMO resolving = (DSDefinitionDMO)((Object)obj.getContainer());
        Iterator<DmcNamedObjectIF> it = ncos.getMatches();
        while (it.hasNext()) {
            DSDefinitionDMO def = (DSDefinitionDMO)it.next();
            if (!resolving.getDmoFromModule().equals(def.getDmoFromModule())) continue;
            rc = def;
            break;
        }
        return rc;
    }

    void addTdlDefinition(TdlDefinitionDMO def) {
        this.TdlDefinitionDefs.add(def);
    }

    @Override
    public int getTdlDefinitionCount() {
        return this.TdlDefinitionDefs.size();
    }

    @Override
    public TdlDefinitionDMO getTdlDefinition(DotName name) {
        return this.TdlDefinitionDefs.getDefinition(name);
    }

    @Override
    public Iterator<TdlDefinitionDMO> getAllTdlDefinition() {
        return this.TdlDefinitionDefs.values().iterator();
    }

    @Override
    public void addContainedElement(ContainedElementDMO def) {
        this.ContainedElementDefs.add(def);
        this.addTdlDefinition(def);
    }

    @Override
    public int getContainedElementCount() {
        return this.ContainedElementDefs.size();
    }

    @Override
    public ContainedElementDMO getContainedElement(DotName name) {
        return this.ContainedElementDefs.getDefinition(name);
    }

    @Override
    public Iterator<ContainedElementDMO> getAllContainedElement() {
        return this.ContainedElementDefs.values().iterator();
    }

    @Override
    public ContainedElementDMO getContainedElementDefinition(String name) throws DmcNameClashException, DmcValueException {
        return this.ContainedElementDefs.getDefinition(name);
    }

    @Override
    public void addExtensionHook(ExtensionHookDMO def) {
        this.ExtensionHookDefs.add(def);
        this.addContainedElement(def);
    }

    @Override
    public int getExtensionHookCount() {
        return this.ExtensionHookDefs.size();
    }

    @Override
    public ExtensionHookDMO getExtensionHook(DotName name) {
        return this.ExtensionHookDefs.getDefinition(name);
    }

    @Override
    public Iterator<ExtensionHookDMO> getAllExtensionHook() {
        return this.ExtensionHookDefs.values().iterator();
    }

    @Override
    public ExtensionHookDMO getExtensionHookDefinition(String name) throws DmcNameClashException, DmcValueException {
        return this.ExtensionHookDefs.getDefinition(name);
    }

    @Override
    public void addSection(SectionDMO def) {
        this.SectionDefs.add(def);
        this.addContainedElement(def);
    }

    @Override
    public int getSectionCount() {
        return this.SectionDefs.size();
    }

    @Override
    public SectionDMO getSection(DotName name) {
        return this.SectionDefs.getDefinition(name);
    }

    @Override
    public Iterator<SectionDMO> getAllSection() {
        return this.SectionDefs.values().iterator();
    }

    @Override
    public SectionDMO getSectionDefinition(String name) throws DmcNameClashException, DmcValueException {
        return this.SectionDefs.getDefinition(name);
    }

    @Override
    public void addTdlModule(TdlModuleDMO def) {
        this.TdlModuleDefs.add(def);
        this.addTdlDefinition(def);
    }

    @Override
    public int getTdlModuleCount() {
        return this.TdlModuleDefs.size();
    }

    @Override
    public TdlModuleDMO getTdlModule(DotName name) {
        return this.TdlModuleDefs.getDefinition(name);
    }

    @Override
    public Iterator<TdlModuleDMO> getAllTdlModule() {
        return this.TdlModuleDefs.values().iterator();
    }

    @Override
    public TdlModuleDMO getTdlModuleDefinition(String name) throws DmcNameClashException, DmcValueException {
        return this.TdlModuleDefs.getDefinition(name);
    }

    @Override
    public void addTextualArtifact(TextualArtifactDMO def) {
        this.TextualArtifactDefs.add(def);
        this.addTdlDefinition(def);
    }

    @Override
    public int getTextualArtifactCount() {
        return this.TextualArtifactDefs.size();
    }

    @Override
    public TextualArtifactDMO getTextualArtifact(DotName name) {
        return this.TextualArtifactDefs.getDefinition(name);
    }

    @Override
    public Iterator<TextualArtifactDMO> getAllTextualArtifact() {
        return this.TextualArtifactDefs.values().iterator();
    }

    @Override
    public TextualArtifactDMO getTextualArtifactDefinition(String name) throws DmcNameClashException, DmcValueException {
        return this.TextualArtifactDefs.getDefinition(name);
    }

    public void addDefinition(DSDefinitionDMO definition) {
        if (definition instanceof ExtensionHookDMO) {
            this.addExtensionHook((ExtensionHookDMO)definition);
        } else if (definition instanceof SectionDMO) {
            this.addSection((SectionDMO)definition);
        } else if (definition instanceof TextualArtifactDMO) {
            this.addTextualArtifact((TextualArtifactDMO)definition);
        } else if (definition instanceof TdlModuleDMO) {
            this.addTdlModule((TdlModuleDMO)definition);
        }
    }

    public String summary() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.TdlDefinitionDefs.summary());
        sb.append(this.ContainedElementDefs.summary());
        sb.append(this.SectionDefs.summary());
        sb.append(this.ExtensionHookDefs.summary());
        sb.append(this.TextualArtifactDefs.summary());
        sb.append(this.TdlModuleDefs.summary());
        return sb.toString();
    }
}

