/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.templates.shared.generated.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.dmd.dmc.DmcEnumIF;

public enum CardinalityEnum implements DmcEnumIF
{
    ONE(0, "Indicates that a section may appear once. You have to manually add the Section."),
    MANY(1, "Indicates that a section will appear many times."),
    STATIC(2, "Indicates that a section is static and will be automatically added.");

    private static final Map<Integer, CardinalityEnum> lookup;
    private static final Map<String, CardinalityEnum> lookupString;
    private int ival;
    private String dval;

    private CardinalityEnum(int i, String d) {
        this.ival = i;
        this.dval = d;
    }

    public int intValue() {
        return this.ival;
    }

    @Override
    public String displayValue() {
        return this.dval;
    }

    public static CardinalityEnum get(int code) {
        return lookup.get(code);
    }

    public static CardinalityEnum get(String str) {
        return lookupString.get(str.toUpperCase());
    }

    static {
        lookup = new HashMap<Integer, CardinalityEnum>();
        for (CardinalityEnum s : EnumSet.allOf(CardinalityEnum.class)) {
            lookup.put(s.intValue(), s);
        }
        lookupString = new HashMap<String, CardinalityEnum>();
        for (CardinalityEnum s : EnumSet.allOf(CardinalityEnum.class)) {
            lookupString.put(s.name(), s);
        }
    }
}

