/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.templates.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.templates.shared.generated.enums.CardinalityEnum;
import org.dmd.templates.shared.generated.types.DmcTypeCardinalityEnum;

public class DmcTypeCardinalityEnumSET
extends DmcTypeCardinalityEnum
implements Serializable {
    private static final Iterator<CardinalityEnum> emptyList = new HashSet().iterator();
    protected Set<CardinalityEnum> value;

    public DmcTypeCardinalityEnumSET() {
        this.value = null;
    }

    public DmcTypeCardinalityEnumSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<CardinalityEnum>() : new TreeSet<CardinalityEnum>();
    }

    public DmcTypeCardinalityEnumSET getNew() {
        return new DmcTypeCardinalityEnumSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<CardinalityEnum> cloneIt() {
        DmcTypeCardinalityEnumSET dmcTypeCardinalityEnumSET = this;
        synchronized (dmcTypeCardinalityEnumSET) {
            DmcTypeCardinalityEnumSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (CardinalityEnum val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CardinalityEnum add(Object v) throws DmcValueException {
        DmcTypeCardinalityEnumSET dmcTypeCardinalityEnumSET = this;
        synchronized (dmcTypeCardinalityEnumSET) {
            CardinalityEnum rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CardinalityEnum del(Object v) {
        DmcTypeCardinalityEnumSET dmcTypeCardinalityEnumSET = this;
        synchronized (dmcTypeCardinalityEnumSET) {
            CardinalityEnum rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<CardinalityEnum> getMV() {
        DmcTypeCardinalityEnumSET dmcTypeCardinalityEnumSET = this;
        synchronized (dmcTypeCardinalityEnumSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<CardinalityEnum>(this.value).iterator();
            }
            return new TreeSet<CardinalityEnum>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<CardinalityEnum> getMVCopy() {
        DmcTypeCardinalityEnumSET dmcTypeCardinalityEnumSET = this;
        synchronized (dmcTypeCardinalityEnumSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<CardinalityEnum>();
                }
                return new HashSet<CardinalityEnum>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<CardinalityEnum>(this.value);
            }
            return new TreeSet<CardinalityEnum>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeCardinalityEnumSET dmcTypeCardinalityEnumSET = this;
        synchronized (dmcTypeCardinalityEnumSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeCardinalityEnumSET dmcTypeCardinalityEnumSET = this;
        synchronized (dmcTypeCardinalityEnumSET) {
            if (this.value == null) {
                return false;
            }
            try {
                CardinalityEnum val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

