/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.templates.shared.generated.types;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.DefinitionName;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.templates.shared.generated.types.ContainedElementREF;
import org.dmd.templates.shared.generated.types.DmcTypeContainedElementREF;

public class DmcTypeContainedElementREFMAP
extends DmcTypeContainedElementREF
implements Serializable {
    private static final Iterator<ContainedElementREF> emptyList = new HashMap().values().iterator();
    protected Map<DefinitionName, ContainedElementREF> value;

    public DmcTypeContainedElementREFMAP() {
        this.value = null;
    }

    public DmcTypeContainedElementREFMAP(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? new HashMap<DefinitionName, ContainedElementREF>() : new TreeMap<DefinitionName, ContainedElementREF>();
    }

    public DefinitionName firstKey() {
        if (this.getAttributeInfo().valueType == ValueTypeEnum.TREEMAPPED) {
            if (this.value == null) {
                return null;
            }
            TreeMap map = (TreeMap)this.value;
            return (DefinitionName)map.firstKey();
        }
        throw new IllegalStateException("Attribute " + this.getAttributeInfo().name + " is HASHMAPPED and doesn't support firstKey()");
    }

    public DmcTypeContainedElementREFMAP getNew() {
        return new DmcTypeContainedElementREFMAP(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<ContainedElementREF> cloneIt() {
        DmcTypeContainedElementREFMAP dmcTypeContainedElementREFMAP = this;
        synchronized (dmcTypeContainedElementREFMAP) {
            DmcTypeContainedElementREFMAP rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (ContainedElementREF val : this.value.values()) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContainedElementREF add(Object v) throws DmcValueException {
        DmcTypeContainedElementREFMAP dmcTypeContainedElementREFMAP = this;
        synchronized (dmcTypeContainedElementREFMAP) {
            DefinitionName key;
            ContainedElementREF oldval;
            ContainedElementREF newval = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if ((oldval = this.value.put(key = (DefinitionName)newval.getKey(), newval)) != null && oldval.valuesAreEqual(newval)) {
                newval = null;
            }
            return newval;
        }
    }

    @Override
    public ContainedElementREF del(Object key) {
        DmcTypeContainedElementREFMAP dmcTypeContainedElementREFMAP = this;
        synchronized (dmcTypeContainedElementREFMAP) {
            if (this.value == null) {
                return null;
            }
            if (key instanceof DefinitionName) {
                return this.value.remove(key);
            }
            throw new IllegalStateException("Incompatible key type: " + key.getClass().getName() + " passed to del():" + this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<ContainedElementREF> getMV() {
        DmcTypeContainedElementREFMAP dmcTypeContainedElementREFMAP = this;
        synchronized (dmcTypeContainedElementREFMAP) {
            if (this.value == null) {
                return emptyList;
            }
            AbstractMap clone = null;
            clone = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? new HashMap<DefinitionName, ContainedElementREF>(this.value) : new TreeMap<DefinitionName, ContainedElementREF>(this.value);
            return clone.values().iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<DefinitionName, ContainedElementREF> getMVCopy() {
        DmcTypeContainedElementREFMAP dmcTypeContainedElementREFMAP = this;
        synchronized (dmcTypeContainedElementREFMAP) {
            AbstractMap clone = null;
            clone = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? (this.value == null ? new HashMap() : new HashMap<DefinitionName, ContainedElementREF>(this.value)) : (this.value == null ? new TreeMap() : new TreeMap<DefinitionName, ContainedElementREF>(this.value));
            return clone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeContainedElementREFMAP dmcTypeContainedElementREFMAP = this;
        synchronized (dmcTypeContainedElementREFMAP) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    @Override
    public ContainedElementREF getByKey(Object key) {
        DmcTypeContainedElementREFMAP dmcTypeContainedElementREFMAP = this;
        synchronized (dmcTypeContainedElementREFMAP) {
            if (this.value == null) {
                return null;
            }
            if (key instanceof DefinitionName) {
                return this.value.get((DefinitionName)key);
            }
            throw new IllegalStateException("Incompatible type: " + key.getClass().getName() + " passed to del():" + this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeContainedElementREFMAP dmcTypeContainedElementREFMAP = this;
        synchronized (dmcTypeContainedElementREFMAP) {
            if (this.value == null) {
                return false;
            }
            try {
                ContainedElementREF val = this.typeCheck(v);
                return this.value.containsValue(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        DmcTypeContainedElementREFMAP dmcTypeContainedElementREFMAP = this;
        synchronized (dmcTypeContainedElementREFMAP) {
            if (this.value == null) {
                return false;
            }
            if (key instanceof DefinitionName) {
                return this.value.containsKey(key);
            }
            return false;
        }
    }
}

