/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.templates.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.templates.shared.generated.types.Contains;
import org.dmd.templates.shared.generated.types.DmcTypeContains;

public class DmcTypeContainsSET
extends DmcTypeContains
implements Serializable {
    private static final Iterator<Contains> emptyList = new HashSet().iterator();
    protected Set<Contains> value;

    public DmcTypeContainsSET() {
        this.value = null;
    }

    public DmcTypeContainsSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<Contains>() : new TreeSet<Contains>();
    }

    public DmcTypeContainsSET getNew() {
        return new DmcTypeContainsSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<Contains> cloneIt() {
        DmcTypeContainsSET dmcTypeContainsSET = this;
        synchronized (dmcTypeContainsSET) {
            DmcTypeContainsSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (Contains val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Contains add(Object v) throws DmcValueException {
        DmcTypeContainsSET dmcTypeContainsSET = this;
        synchronized (dmcTypeContainsSET) {
            Contains rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Contains del(Object v) {
        DmcTypeContainsSET dmcTypeContainsSET = this;
        synchronized (dmcTypeContainsSET) {
            Contains rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Contains> getMV() {
        DmcTypeContainsSET dmcTypeContainsSET = this;
        synchronized (dmcTypeContainsSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<Contains>(this.value).iterator();
            }
            return new TreeSet<Contains>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Contains> getMVCopy() {
        DmcTypeContainsSET dmcTypeContainsSET = this;
        synchronized (dmcTypeContainsSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<Contains>();
                }
                return new HashSet<Contains>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<Contains>(this.value);
            }
            return new TreeSet<Contains>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeContainsSET dmcTypeContainsSET = this;
        synchronized (dmcTypeContainsSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeContainsSET dmcTypeContainsSET = this;
        synchronized (dmcTypeContainsSET) {
            if (this.value == null) {
                return false;
            }
            try {
                Contains val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

