/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.templates.shared.generated.types;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.types.DefinitionName;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.templates.shared.generated.types.DmcTypeSectionREF;
import org.dmd.templates.shared.generated.types.SectionREF;

public class DmcTypeSectionREFMAP
extends DmcTypeSectionREF
implements Serializable {
    private static final Iterator<SectionREF> emptyList = new HashMap().values().iterator();
    protected Map<DefinitionName, SectionREF> value;

    public DmcTypeSectionREFMAP() {
        this.value = null;
    }

    public DmcTypeSectionREFMAP(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? new HashMap<DefinitionName, SectionREF>() : new TreeMap<DefinitionName, SectionREF>();
    }

    public DefinitionName firstKey() {
        if (this.getAttributeInfo().valueType == ValueTypeEnum.TREEMAPPED) {
            if (this.value == null) {
                return null;
            }
            TreeMap map = (TreeMap)this.value;
            return (DefinitionName)map.firstKey();
        }
        throw new IllegalStateException("Attribute " + this.getAttributeInfo().name + " is HASHMAPPED and doesn't support firstKey()");
    }

    public DmcTypeSectionREFMAP getNew() {
        return new DmcTypeSectionREFMAP(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<SectionREF> cloneIt() {
        DmcTypeSectionREFMAP dmcTypeSectionREFMAP = this;
        synchronized (dmcTypeSectionREFMAP) {
            DmcTypeSectionREFMAP rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (SectionREF val : this.value.values()) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SectionREF add(Object v) throws DmcValueException {
        DmcTypeSectionREFMAP dmcTypeSectionREFMAP = this;
        synchronized (dmcTypeSectionREFMAP) {
            DefinitionName key;
            SectionREF oldval;
            SectionREF newval = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if ((oldval = this.value.put(key = (DefinitionName)newval.getKey(), newval)) != null && oldval.valuesAreEqual(newval)) {
                newval = null;
            }
            return newval;
        }
    }

    @Override
    public SectionREF del(Object key) {
        DmcTypeSectionREFMAP dmcTypeSectionREFMAP = this;
        synchronized (dmcTypeSectionREFMAP) {
            if (this.value == null) {
                return null;
            }
            if (key instanceof DefinitionName) {
                return this.value.remove(key);
            }
            throw new IllegalStateException("Incompatible key type: " + key.getClass().getName() + " passed to del():" + this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<SectionREF> getMV() {
        DmcTypeSectionREFMAP dmcTypeSectionREFMAP = this;
        synchronized (dmcTypeSectionREFMAP) {
            if (this.value == null) {
                return emptyList;
            }
            AbstractMap clone = null;
            clone = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? new HashMap<DefinitionName, SectionREF>(this.value) : new TreeMap<DefinitionName, SectionREF>(this.value);
            return clone.values().iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<DefinitionName, SectionREF> getMVCopy() {
        DmcTypeSectionREFMAP dmcTypeSectionREFMAP = this;
        synchronized (dmcTypeSectionREFMAP) {
            AbstractMap clone = null;
            clone = this.getAttributeInfo().valueType == ValueTypeEnum.HASHMAPPED ? (this.value == null ? new HashMap() : new HashMap<DefinitionName, SectionREF>(this.value)) : (this.value == null ? new TreeMap() : new TreeMap<DefinitionName, SectionREF>(this.value));
            return clone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeSectionREFMAP dmcTypeSectionREFMAP = this;
        synchronized (dmcTypeSectionREFMAP) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    @Override
    public SectionREF getByKey(Object key) {
        DmcTypeSectionREFMAP dmcTypeSectionREFMAP = this;
        synchronized (dmcTypeSectionREFMAP) {
            if (this.value == null) {
                return null;
            }
            if (key instanceof DefinitionName) {
                return this.value.get((DefinitionName)key);
            }
            throw new IllegalStateException("Incompatible type: " + key.getClass().getName() + " passed to del():" + this.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeSectionREFMAP dmcTypeSectionREFMAP = this;
        synchronized (dmcTypeSectionREFMAP) {
            if (this.value == null) {
                return false;
            }
            try {
                SectionREF val = this.typeCheck(v);
                return this.value.containsValue(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        DmcTypeSectionREFMAP dmcTypeSectionREFMAP = this;
        synchronized (dmcTypeSectionREFMAP) {
            if (this.value == null) {
                return false;
            }
            if (key instanceof DefinitionName) {
                return this.value.containsKey(key);
            }
            return false;
        }
    }
}

