/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.templates.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.templates.shared.generated.types.DmcTypeSectionREF;
import org.dmd.templates.shared.generated.types.SectionREF;

public class DmcTypeSectionREFSET
extends DmcTypeSectionREF
implements Serializable {
    private static final Iterator<SectionREF> emptyList = new HashSet().iterator();
    protected Set<SectionREF> value;

    public DmcTypeSectionREFSET() {
        this.value = null;
    }

    public DmcTypeSectionREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<SectionREF>() : new TreeSet<SectionREF>();
    }

    public DmcTypeSectionREFSET getNew() {
        return new DmcTypeSectionREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<SectionREF> cloneIt() {
        DmcTypeSectionREFSET dmcTypeSectionREFSET = this;
        synchronized (dmcTypeSectionREFSET) {
            DmcTypeSectionREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (SectionREF val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SectionREF add(Object v) throws DmcValueException {
        DmcTypeSectionREFSET dmcTypeSectionREFSET = this;
        synchronized (dmcTypeSectionREFSET) {
            SectionREF rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SectionREF del(Object v) {
        DmcTypeSectionREFSET dmcTypeSectionREFSET = this;
        synchronized (dmcTypeSectionREFSET) {
            SectionREF rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<SectionREF> getMV() {
        DmcTypeSectionREFSET dmcTypeSectionREFSET = this;
        synchronized (dmcTypeSectionREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<SectionREF>(this.value).iterator();
            }
            return new TreeSet<SectionREF>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<SectionREF> getMVCopy() {
        DmcTypeSectionREFSET dmcTypeSectionREFSET = this;
        synchronized (dmcTypeSectionREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<SectionREF>();
                }
                return new HashSet<SectionREF>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<SectionREF>(this.value);
            }
            return new TreeSet<SectionREF>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeSectionREFSET dmcTypeSectionREFSET = this;
        synchronized (dmcTypeSectionREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeSectionREFSET dmcTypeSectionREFSET = this;
        synchronized (dmcTypeSectionREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                SectionREF val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

