/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.templates.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.templates.shared.generated.types.DmcTypeTdlModuleREF;
import org.dmd.templates.shared.generated.types.TdlModuleREF;

public class DmcTypeTdlModuleREFSET
extends DmcTypeTdlModuleREF
implements Serializable {
    private static final Iterator<TdlModuleREF> emptyList = new HashSet().iterator();
    protected Set<TdlModuleREF> value;

    public DmcTypeTdlModuleREFSET() {
        this.value = null;
    }

    public DmcTypeTdlModuleREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<TdlModuleREF>() : new TreeSet<TdlModuleREF>();
    }

    public DmcTypeTdlModuleREFSET getNew() {
        return new DmcTypeTdlModuleREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<TdlModuleREF> cloneIt() {
        DmcTypeTdlModuleREFSET dmcTypeTdlModuleREFSET = this;
        synchronized (dmcTypeTdlModuleREFSET) {
            DmcTypeTdlModuleREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (TdlModuleREF val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TdlModuleREF add(Object v) throws DmcValueException {
        DmcTypeTdlModuleREFSET dmcTypeTdlModuleREFSET = this;
        synchronized (dmcTypeTdlModuleREFSET) {
            TdlModuleREF rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TdlModuleREF del(Object v) {
        DmcTypeTdlModuleREFSET dmcTypeTdlModuleREFSET = this;
        synchronized (dmcTypeTdlModuleREFSET) {
            TdlModuleREF rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<TdlModuleREF> getMV() {
        DmcTypeTdlModuleREFSET dmcTypeTdlModuleREFSET = this;
        synchronized (dmcTypeTdlModuleREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<TdlModuleREF>(this.value).iterator();
            }
            return new TreeSet<TdlModuleREF>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<TdlModuleREF> getMVCopy() {
        DmcTypeTdlModuleREFSET dmcTypeTdlModuleREFSET = this;
        synchronized (dmcTypeTdlModuleREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<TdlModuleREF>();
                }
                return new HashSet<TdlModuleREF>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<TdlModuleREF>(this.value);
            }
            return new TreeSet<TdlModuleREF>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeTdlModuleREFSET dmcTypeTdlModuleREFSET = this;
        synchronized (dmcTypeTdlModuleREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeTdlModuleREFSET dmcTypeTdlModuleREFSET = this;
        synchronized (dmcTypeTdlModuleREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                TdlModuleREF val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

