/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.templates.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.templates.shared.generated.types.DmcTypeTemplateREF;
import org.dmd.templates.shared.generated.types.TemplateREF;

public class DmcTypeTemplateREFSET
extends DmcTypeTemplateREF
implements Serializable {
    private static final Iterator<TemplateREF> emptyList = new HashSet().iterator();
    protected Set<TemplateREF> value;

    public DmcTypeTemplateREFSET() {
        this.value = null;
    }

    public DmcTypeTemplateREFSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<TemplateREF>() : new TreeSet<TemplateREF>();
    }

    public DmcTypeTemplateREFSET getNew() {
        return new DmcTypeTemplateREFSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<TemplateREF> cloneIt() {
        DmcTypeTemplateREFSET dmcTypeTemplateREFSET = this;
        synchronized (dmcTypeTemplateREFSET) {
            DmcTypeTemplateREFSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (TemplateREF val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TemplateREF add(Object v) throws DmcValueException {
        DmcTypeTemplateREFSET dmcTypeTemplateREFSET = this;
        synchronized (dmcTypeTemplateREFSET) {
            TemplateREF rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TemplateREF del(Object v) {
        DmcTypeTemplateREFSET dmcTypeTemplateREFSET = this;
        synchronized (dmcTypeTemplateREFSET) {
            TemplateREF rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<TemplateREF> getMV() {
        DmcTypeTemplateREFSET dmcTypeTemplateREFSET = this;
        synchronized (dmcTypeTemplateREFSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<TemplateREF>(this.value).iterator();
            }
            return new TreeSet<TemplateREF>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<TemplateREF> getMVCopy() {
        DmcTypeTemplateREFSET dmcTypeTemplateREFSET = this;
        synchronized (dmcTypeTemplateREFSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<TemplateREF>();
                }
                return new HashSet<TemplateREF>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<TemplateREF>(this.value);
            }
            return new TreeSet<TemplateREF>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeTemplateREFSET dmcTypeTemplateREFSET = this;
        synchronized (dmcTypeTemplateREFSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeTemplateREFSET dmcTypeTemplateREFSET = this;
        synchronized (dmcTypeTemplateREFSET) {
            if (this.value == null) {
                return false;
            }
            try {
                TemplateREF val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

