/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.templates.shared.generated.types;

import java.io.Serializable;
import java.util.Iterator;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcInputStreamIF;
import org.dmd.dmc.DmcOutputStreamIF;
import org.dmd.dmc.DmcValueException;
import org.dmd.templates.shared.generated.types.Value;

public abstract class DmcTypeValue
extends DmcAttribute<Value>
implements Serializable {
    public DmcTypeValue() {
    }

    public DmcTypeValue(DmcAttributeInfo ai) {
        super(ai);
    }

    @Override
    public void formatValueAsJSON(StringBuffer sb, int padding, String indent) {
        if (this.getMVSize() == 0) {
            ((Value)this.getSV()).toJSON(sb, padding, indent);
        } else {
            Iterator it = this.getMV();
            while (it.hasNext()) {
                Value value = (Value)it.next();
                value.toJSON(sb, padding, indent);
                if (!it.hasNext()) continue;
                sb.append(", \n");
            }
        }
    }

    @Override
    public Value typeCheck(Object value) throws DmcValueException {
        Value rc = null;
        if (value instanceof Value) {
            rc = (Value)value;
        } else if (value instanceof String) {
            rc = new Value((String)value);
        } else {
            throw new DmcValueException("Object of class: " + value.getClass().getName() + " passed where object compatible with Value expected.");
        }
        return rc;
    }

    @Override
    public Value cloneValue(Value val) {
        return new Value(val);
    }

    @Override
    public void serializeValue(DmcOutputStreamIF dos, Value value) throws Exception {
        value.serializeIt(dos);
    }

    @Override
    public Value deserializeValue(DmcInputStreamIF dis) throws Exception {
        Value rc = new Value();
        rc.deserializeIt(dis);
        return rc;
    }
}

