/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.templates.shared.generated.types;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcValueException;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.templates.shared.generated.types.DmcTypeValue;
import org.dmd.templates.shared.generated.types.Value;

public class DmcTypeValueSET
extends DmcTypeValue
implements Serializable {
    private static final Iterator<Value> emptyList = new HashSet().iterator();
    protected Set<Value> value;

    public DmcTypeValueSET() {
        this.value = null;
    }

    public DmcTypeValueSET(DmcAttributeInfo ai) {
        super(ai);
        this.initValue();
    }

    void initValue() {
        this.value = this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET ? new HashSet<Value>() : new TreeSet<Value>();
    }

    public DmcTypeValueSET getNew() {
        return new DmcTypeValueSET(this.getAttributeInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DmcAttribute<Value> cloneIt() {
        DmcTypeValueSET dmcTypeValueSET = this;
        synchronized (dmcTypeValueSET) {
            DmcTypeValueSET rc = this.getNew();
            if (this.value == null) {
                return rc;
            }
            for (Value val : this.value) {
                try {
                    rc.add(val);
                }
                catch (DmcValueException e) {
                    throw new IllegalStateException("typeCheck() should never fail here!", e);
                }
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value add(Object v) throws DmcValueException {
        DmcTypeValueSET dmcTypeValueSET = this;
        synchronized (dmcTypeValueSET) {
            Value rc = this.typeCheck(v);
            if (this.value == null) {
                this.initValue();
            }
            if (!this.value.add(rc)) {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value del(Object v) {
        DmcTypeValueSET dmcTypeValueSET = this;
        synchronized (dmcTypeValueSET) {
            Value rc = null;
            if (this.value == null) {
                return rc;
            }
            try {
                rc = this.typeCheck(v);
            }
            catch (DmcValueException e) {
                throw new IllegalStateException("Incompatible type passed to del():" + this.getName(), e);
            }
            if (this.value.contains(rc)) {
                this.value.remove(rc);
                if (this.value.size() == 0) {
                    this.value = null;
                }
            } else {
                rc = null;
            }
            return rc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Value> getMV() {
        DmcTypeValueSET dmcTypeValueSET = this;
        synchronized (dmcTypeValueSET) {
            if (this.value == null) {
                return emptyList;
            }
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                return new HashSet<Value>(this.value).iterator();
            }
            return new TreeSet<Value>(this.value).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Value> getMVCopy() {
        DmcTypeValueSET dmcTypeValueSET = this;
        synchronized (dmcTypeValueSET) {
            if (this.getAttributeInfo().valueType == ValueTypeEnum.HASHSET) {
                if (this.value == null) {
                    return new HashSet<Value>();
                }
                return new HashSet<Value>(this.value);
            }
            if (this.value == null) {
                return new TreeSet<Value>(this.value);
            }
            return new TreeSet<Value>(this.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMVSize() {
        DmcTypeValueSET dmcTypeValueSET = this;
        synchronized (dmcTypeValueSET) {
            if (this.value == null) {
                return 0;
            }
            return this.value.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object v) {
        DmcTypeValueSET dmcTypeValueSET = this;
        synchronized (dmcTypeValueSET) {
            if (this.value == null) {
                return false;
            }
            try {
                Value val = this.typeCheck(v);
                return this.value.contains(val);
            }
            catch (DmcValueException e) {
                return false;
            }
        }
    }
}

