/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.templates.shared.generated.types;

import java.io.Serializable;
import java.util.ArrayList;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcInputStreamIF;
import org.dmd.dmc.DmcOutputStreamIF;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmc.util.ComplexTypeSplitter;
import org.dmd.dmc.util.JSONUtil;
import org.dmd.dmc.util.ParsedNameValuePair;
import org.dmd.dms.generated.enums.DataTypeEnum;
import org.dmd.dms.generated.enums.ValueTypeEnum;
import org.dmd.dms.generated.types.DmcTypeStringSTATIC;

public class Value
implements Serializable {
    static final int requiredParts = 2;
    String valueNameV;
    static final DmcAttributeInfo valueNameAI = new DmcAttributeInfo("valueName", 0, "String", ValueTypeEnum.SINGLE, DataTypeEnum.UNKNOWN, 0, false);
    String descriptionV;
    static final DmcAttributeInfo descriptionAI = new DmcAttributeInfo("description", 0, "String", ValueTypeEnum.SINGLE, DataTypeEnum.UNKNOWN, 0, false);

    public Value() {
    }

    public Value(Value original) {
        this.valueNameV = original.valueNameV;
        this.descriptionV = original.descriptionV;
    }

    public Value(String valueName_, String description_) throws DmcValueException {
        this.valueNameV = DmcTypeStringSTATIC.instance.typeCheck(valueName_);
        this.descriptionV = DmcTypeStringSTATIC.instance.typeCheck(description_);
    }

    public Value(String initialInput) throws DmcValueException {
        this.initialize(initialInput);
    }

    void initialize(String initialInput) throws DmcValueException {
        ArrayList<ParsedNameValuePair> nvp = ComplexTypeSplitter.parse(initialInput);
        if (nvp.size() < 2) {
            throw new DmcValueException("Missing required values for complex type: Value\nValue: " + initialInput);
        }
        this.valueNameV = DmcTypeStringSTATIC.instance.typeCheck(nvp.get(0).getValue());
        this.descriptionV = DmcTypeStringSTATIC.instance.typeCheck(nvp.get(1).getValue());
    }

    public void serializeIt(DmcOutputStreamIF dos) throws Exception {
        dos.writeUTF(this.toString());
    }

    public void deserializeIt(DmcInputStreamIF dis) throws Exception {
        this.initialize(dis.readUTF());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.valueNameV.toString());
        sb.append(' ');
        sb.append("\"" + this.descriptionV.toString() + "\"");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Value) {
            return this.toString().equals(((Value)obj).toString());
        }
        return false;
    }

    public void toJSON(StringBuffer sb, int padding, String indent) {
        sb.append(indent + "{\n");
        sb.append(indent + "  \"valueName\": \"" + JSONUtil.escape(this.valueNameV.toString()) + "\",\n");
        sb.append(indent + "  \"description\": \"" + JSONUtil.escape(this.descriptionV.toString()) + "\"");
        sb.append("\n" + indent + "}");
    }

    public String getValueName() {
        return this.valueNameV;
    }

    public String getDescription() {
        return this.descriptionV;
    }
}

