/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.templates.tools.xml;

import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Stack;
import org.dmd.templates.tools.xml.XmlDeclaration;
import org.dmd.templates.tools.xml.XmlElement;
import org.dmd.templates.tools.xml.XmlText;
import org.dmd.util.exceptions.DebugInfo;
import org.dmd.util.exceptions.ResultException;

public class XmlAnalyzer {
    XmlDeclaration declaration;
    boolean strict;
    ArrayList<XmlElement> topElements;
    Stack<XmlElement> stack;
    int depth;
    State state = State.start;
    LineNumberReader in;
    String fileName;

    public XmlDeclaration getDeclaration() {
        return this.declaration;
    }

    public ArrayList<XmlElement> getTopElements() {
        return this.topElements;
    }

    public int getDepth() {
        return this.depth;
    }

    public void parse(String fn, boolean strictFlag) throws ResultException, IOException {
        String str;
        this.state = State.start;
        this.declaration = null;
        this.topElements = new ArrayList();
        this.stack = new Stack();
        this.strict = strictFlag;
        this.in = new LineNumberReader(new FileReader(fn));
        this.fileName = fn;
        StringBuffer tagName = null;
        StringBuffer attributeInfo = null;
        StringBuffer bodyInfo = null;
        StringBuffer commentInfo = null;
        String lastString = null;
        block26: while ((str = this.in.readLine()) != null) {
            if ((str = str.trim()).length() == 0) continue;
            lastString = str;
            for (int i = 0; i < str.length(); ++i) {
                System.out.println("i = " + i + " : " + str.charAt(i) + "     - " + this.state.name());
                switch (this.state) {
                    case start: {
                        if (str.charAt(i) == '<') {
                            this.state = State.lookingForElementNameStart;
                            tagName = new StringBuffer();
                            break;
                        }
                        if (Character.isWhitespace(str.charAt(i))) break;
                        this.throwError("Expecting < ", i, str);
                        break;
                    }
                    case lookingForElementNameStart: {
                        if (str.charAt(i) == '?') {
                            this.state = State.parsingXmlDeclaration;
                            break;
                        }
                        if (str.charAt(i) == '!') {
                            this.state = State.parsingComment;
                            commentInfo = new StringBuffer();
                            break;
                        }
                        if (Character.isWhitespace(str.charAt(i))) {
                            if (tagName.length() == 0) {
                                this.throwError("Expecting tag name, not whitespace", i, str);
                                break;
                            }
                            this.pushElement(tagName.toString(), this.in.getLineNumber());
                            tagName = null;
                            this.state = State.lookingForEndBracketOfOpenTag;
                            break;
                        }
                        if (str.charAt(i) == '>') {
                            if (tagName.length() == 0) {
                                this.throwError("Expecting tag name, not closing >", i, str);
                                break;
                            }
                            this.pushElement(tagName.toString(), this.in.getLineNumber());
                            tagName = null;
                            this.state = State.parsingBody;
                            break;
                        }
                        if (str.charAt(i) == '/') {
                            this.pushElement(tagName.toString(), this.in.getLineNumber());
                            tagName = null;
                            this.state = State.nextCharMustBeEndBracket;
                            break;
                        }
                        if (str.charAt(i) == '<') {
                            this.throwError("Expecting closure of tag name, or attributes, not < ", i, str);
                            break;
                        }
                        tagName.append(str.charAt(i));
                        break;
                    }
                    case nextCharMustBeEndBracket: {
                        if (Character.isWhitespace(str.charAt(i))) break;
                        if (str.charAt(i) != '>') {
                            this.throwError("Expecting end bracket >", i, str);
                            break;
                        }
                        this.stack.peek().setEmpty();
                        this.stack.pop();
                        this.state = State.start;
                        break;
                    }
                    case parsingXmlDeclaration: {
                        break;
                    }
                    case lookingForEndBracketOfOpenTag: {
                        if (str.charAt(i) == '>') {
                            this.state = State.parsingBody;
                            break;
                        }
                        if (str.charAt(i) == '/') {
                            this.state = State.nextCharMustBeEndBracket;
                            break;
                        }
                        if (Character.isWhitespace(str.charAt(i))) break;
                        attributeInfo = new StringBuffer();
                        attributeInfo.append(str.charAt(i));
                        this.state = State.parsingAttributes;
                        break;
                    }
                    case parsingAttributes: {
                        if (str.charAt(i) == '>') {
                            this.state = State.parsingBody;
                            break;
                        }
                        if (str.charAt(i) == '/') {
                            this.state = State.nextCharMustBeEndBracket;
                            break;
                        }
                        attributeInfo.append(str.charAt(i));
                        break;
                    }
                    case parsingBody: {
                        if (bodyInfo == null) {
                            bodyInfo = new StringBuffer();
                        }
                        if (str.charAt(i) == '<') {
                            if (bodyInfo.length() > 0) {
                                this.stack.peek().addText(new XmlText(bodyInfo.toString()));
                            }
                            bodyInfo = null;
                            this.state = State.startOrStopTag;
                            break;
                        }
                        bodyInfo.append(str.charAt(i));
                        break;
                    }
                    case startOrStopTag: {
                        if (Character.isWhitespace(str.charAt(i))) {
                            this.throwError("Expecting the / of an end tag or start of a tag name.", i, str);
                            break;
                        }
                        if (str.charAt(i) == '/') {
                            this.state = State.lookingForEndBracketOfCloseTag;
                            tagName = new StringBuffer();
                            break;
                        }
                        if (str.charAt(i) == '>') {
                            this.throwError("Expecting tag name, but found >", i, str);
                            break;
                        }
                        this.state = State.lookingForElementNameStart;
                        tagName = new StringBuffer();
                        tagName.append(str.charAt(i));
                        break;
                    }
                    case lookingForEndBracketOfCloseTag: {
                        if (Character.isWhitespace(str.charAt(i))) {
                            if (tagName.length() == 0) {
                                this.throwError("Expecting end tag name, not whitespace", i, str);
                                break;
                            }
                            this.throwError("Extraneous space with end tag name", i, str);
                            break;
                        }
                        if (str.charAt(i) == '>') {
                            String endName = tagName.toString();
                            if (this.stack.peek().name().equals(endName)) {
                                this.stack.pop();
                                this.state = State.parseBodyOrTag;
                                break;
                            }
                            this.throwError("Expecting end tag for " + this.stack.peek().name() + " element, but got end tag for " + endName + " instead");
                            break;
                        }
                        tagName.append(str.charAt(i));
                        break;
                    }
                    case parseBodyOrTag: {
                        if (Character.isWhitespace(str.charAt(i))) break;
                        if (str.charAt(i) == '<') {
                            this.state = State.startOrStopTag;
                            break;
                        }
                        bodyInfo = new StringBuffer();
                        bodyInfo.append(str.charAt(i));
                        this.state = State.parsingBody;
                        break;
                    }
                    case parsingComment: {
                        if (str.charAt(i) != '>') break;
                    }
                }
                if (this.state != State.parsingXmlDeclaration) continue;
                this.parseDeclaration(str);
                continue block26;
            }
        }
        switch (this.state) {
            case lookingForElementNameStart: {
                break;
            }
            case lookingForEndBracketOfOpenTag: {
                break;
            }
            case nextCharMustBeEndBracket: {
                break;
            }
            case parsingAttributes: {
                break;
            }
            case parsingBody: {
                break;
            }
            case parsingXmlDeclaration: {
                break;
            }
            case start: {
                break;
            }
            case lookingForEndBracketOfCloseTag: {
                break;
            }
            case parseBodyOrTag: {
                break;
            }
            case parsingComment: {
                break;
            }
            case startOrStopTag: {
                break;
            }
        }
        if (!this.stack.isEmpty()) {
            this.throwError(this.stack.peek().name() + " not properly terminated.", 0, lastString);
        }
        this.in.close();
    }

    void pushElement(String name, int line) throws ResultException, IOException {
        String test = name.toLowerCase();
        if (test.startsWith("xml")) {
            this.throwError("Tag name can't start with xml:" + name);
        }
        if (!Character.isLetter(name.charAt(0))) {
            this.throwError("Tag names must start with a letter:" + name);
        }
        XmlElement xe = new XmlElement(name, line);
        DebugInfo.debug("Pushing element: " + name);
        if (this.stack.size() == 0) {
            if (this.strict && this.topElements.size() != 0) {
                ResultException ex = new ResultException("An XML file should have only one top level element");
                ex.setLocationInfo(this.fileName, line);
                throw ex;
            }
            this.topElements.add(xe);
        }
        if (this.stack.size() > 0) {
            this.stack.peek().addElement(xe);
        }
        this.stack.push(xe);
        if (this.stack.size() > this.depth) {
            this.depth = this.stack.size();
        }
    }

    void throwError(String message, int position, String input) throws ResultException, IOException {
        this.in.close();
        ResultException ex = new ResultException(message);
        ex.setLocationInfo(this.fileName, this.in.getLineNumber());
        ex.result.lastResult().moreMessages(this.showErrorLocation(position, input));
        throw ex;
    }

    void throwError(String message) throws ResultException, IOException {
        this.in.close();
        ResultException ex = new ResultException(message);
        ex.setLocationInfo(this.fileName, this.in.getLineNumber());
        throw ex;
    }

    void parseDeclaration(String str) throws ResultException {
        if (!str.endsWith("?>")) {
            ResultException ex = new ResultException("Missing ?> tag for XML declaration");
            throw ex;
        }
        this.declaration = new XmlDeclaration();
        this.state = State.start;
    }

    void parseAttributes(StringBuffer attributeInfo) {
    }

    String showErrorLocation(int position, String input) {
        StringBuffer sb = new StringBuffer("\n" + input + "\n");
        for (int i = 0; i < position; ++i) {
            sb.append(" ");
        }
        sb.append("^");
        return sb.toString();
    }

    static enum State {
        start,
        lookingForElementNameStart,
        parsingXmlDeclaration,
        nextCharMustBeEndBracket,
        parseBodyOrTag,
        parsingBody,
        parsingAttributes,
        parsingComment,
        startOrStopTag,
        lookingForEndBracketOfCloseTag,
        lookingForEndBracketOfOpenTag;

    }
}

