/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.templates.tools.xml;

import java.util.ArrayList;
import org.dmd.dmc.util.ParsedNameValuePair;
import org.dmd.templates.tools.xml.XmlPart;
import org.dmd.templates.tools.xml.XmlText;

public class XmlElement
extends XmlPart {
    String name;
    String body;
    boolean empty;
    ArrayList<XmlPart> subParts;
    ArrayList<ParsedNameValuePair> attributes;
    String attrString;
    int line;

    public XmlElement(String n, int l) {
        this.name = n;
        this.body = null;
        this.empty = false;
        this.subParts = null;
        this.attributes = null;
        this.attrString = null;
        this.line = l;
    }

    public int subElementCount() {
        if (this.subParts == null) {
            return 0;
        }
        return this.subParts.size();
    }

    public String name() {
        return this.name;
    }

    public void addText(XmlText xt) {
        if (this.subParts == null) {
            this.subParts = new ArrayList();
        }
        this.subParts.add(xt);
    }

    public String body() {
        return this.body;
    }

    public void setEmpty() {
        this.empty = true;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public void attributes(String attributeInfo) {
        this.attrString = attributeInfo;
    }

    public void addElement(XmlElement xe) {
        if (this.subParts == null) {
            this.subParts = new ArrayList();
        }
        this.subParts.add(xe);
    }

    public String toString() {
        return this.toString("");
    }

    @Override
    public String toString(String indent) {
        if (this.empty) {
            return indent + "<" + this.name + " />";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(indent + "<" + this.name + " ");
        if (this.attributes != null) {
            // empty if block
        }
        if (this.attrString != null) {
            sb.append(this.attrString);
        }
        sb.append(">\n");
        if (this.body != null) {
            sb.append(this.body + "\n");
        }
        if (this.subParts != null) {
            for (XmlPart xe : this.subParts) {
                sb.append(xe.toString(indent + "  "));
            }
        }
        sb.append(indent + "</" + this.name + ">");
        return sb.toString();
    }
}

