/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.dmd.util.exceptions.DebugInfo;
import org.dmd.util.exceptions.ResultException;

public class Callback {
    Object targetObj = null;
    Method method = null;
    String methodName;
    Class<?>[] parms;
    Object[] args;
    int currParm;

    public Callback(int argCount) {
        this.parms = new Class[argCount];
        this.args = new Object[argCount];
        this.currParm = 0;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void addParm(String name) throws ResultException {
        Class<?> c;
        try {
            c = Class.forName(name);
        }
        catch (Exception e) {
            ResultException ex = new ResultException();
            ex.result.addResult(3, "Couldn't retrieve Class for " + name);
            throw ex;
        }
        this.parms[this.currParm++] = c;
    }

    public void addParm(Class<?> c) {
        this.parms[this.currParm++] = c;
    }

    public void initialize(Object cbobj, String cbfun) throws ResultException {
        this.targetObj = cbobj;
        this.methodName = new String(cbfun);
        try {
            this.method = cbobj.getClass().getMethod(cbfun, this.parms);
        }
        catch (NoSuchMethodException e) {
            ResultException ex = new ResultException();
            ex.result.addResult(3, "Unknown callback function: " + cbfun);
            ex.result.lastResult().moreMessages(DebugInfo.getCurrentStack());
            throw ex;
        }
        catch (SecurityException e) {
            ResultException ex = new ResultException();
            ex.result.addResult(3, "Security exception: " + e.getMessage());
            ex.result.lastResult().moreMessages(DebugInfo.getCurrentStack());
        }
    }

    public void setArg(int argNum, Object o) {
        this.args[argNum] = o;
    }

    public int getArgsCount() {
        if (this.args == null) {
            return 0;
        }
        return this.args.length;
    }

    public void invoke() throws ResultException {
        try {
            this.method.invoke(this.targetObj, this.args);
        }
        catch (InvocationTargetException e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            ResultException ex = new ResultException();
            ex.result.addResult(3, "Invocation failed for method: " + this.methodName + " on " + this.targetObj.getClass().getName());
            ex.result.lastResult().moreMessages(sw.toString());
            throw ex;
        }
        catch (IllegalAccessException e) {
            ResultException ex = new ResultException();
            ex.result.addResult(3, "Couldn't invoke method: " + this.methodName + " " + e.toString());
            throw ex;
        }
        catch (IllegalArgumentException e) {
            ResultException ex = new ResultException();
            ex.result.addResult(3, "Couldn't invoke method: " + this.methodName + " " + e.toString());
            throw ex;
        }
    }
}

