/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.util;

import java.io.DataInputStream;
import java.io.InputStream;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcFilter;
import org.dmd.dmc.DmcInputStreamIF;
import org.dmd.dmc.DmcObject;
import org.dmd.dmc.DmcObjectName;
import org.dmd.dmc.types.DmcTypeNamedObjectREF;
import org.dmd.dms.ClassDefinition;
import org.dmd.dms.SchemaManager;
import org.dmd.dms.generated.types.ClassDefinitionREF;
import org.dmd.dmw.DmwWrapper;
import org.dmd.util.exceptions.DebugInfo;

public class DmcInputStream
extends DataInputStream
implements DmcInputStreamIF {
    SchemaManager schema;

    public DmcInputStream(InputStream is, SchemaManager sm) {
        super(is);
        this.schema = sm;
    }

    @Override
    public DmcAttribute<?> getAttributeInstance(DmcAttributeInfo ai) throws Exception {
        return this.schema.getAttributeInstance(ai.id);
    }

    @Override
    public DmcAttribute<?> getAttributeInstance(Integer id) throws Exception {
        return this.schema.getAttributeInstance(id);
    }

    @Override
    public void resolveReferences(DmcTypeNamedObjectREF<?, ?> attr) throws Exception {
        attr.resolveReferences(this.schema);
    }

    @Override
    public int readAttributeCount() throws Exception {
        return this.readShort();
    }

    @Override
    public int readAttributeID() throws Exception {
        return this.readShort();
    }

    @Override
    public int readValueCount() throws Exception {
        short high = this.readShort();
        if (high < 0) {
            short low = this.readShort();
            return (high & Short.MAX_VALUE) << 16 | low & 0xFFFF;
        }
        return high;
    }

    @Override
    public DmcAttribute<?> getAttributeInstance() throws Exception {
        int id = this.readAttributeID();
        return this.getAttributeInstance(id);
    }

    @Override
    public DmcObjectName getNameValueInstance() throws Exception {
        int id = this.readAttributeID();
        return this.schema.getNameValueInstance(id);
    }

    @Override
    public DmcFilter getFilterValueInstance() throws Exception {
        DebugInfo.debug("NOT IMPLEMENTED YET");
        return null;
    }

    @Override
    public DmcObject getDMOInstance(DmcInputStreamIF dis) throws Exception {
        DmcObject rc = null;
        int classCount = dis.readInt();
        int classID = dis.readInt();
        ClassDefinition cd = this.schema.isClass(classID);
        if (cd == null) {
            throw new IllegalStateException("Unknown class ID: " + classID + " ensure that you have loaded the required schemas.");
        }
        DmwWrapper wrapper = null;
        try {
            wrapper = cd.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        rc = wrapper == null ? cd.newDMOInstance() : wrapper.getDmcObject();
        if (classCount > 1) {
            for (int i = 1; i < classCount; ++i) {
                classID = dis.readInt();
                cd = this.schema.isClass(classID);
                rc.addAux(new ClassDefinitionREF(cd.getDMO()));
            }
        }
        return rc;
    }

    @Override
    public int readBytes(byte[] b) throws Exception {
        return super.read(b);
    }
}

