/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.util;

import java.io.DataOutputStream;
import java.io.OutputStream;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcOutputStreamIF;

public class DmcOutputStream
extends DataOutputStream
implements DmcOutputStreamIF {
    boolean isFile;

    public DmcOutputStream(OutputStream os) {
        super(os);
        this.isFile = true;
    }

    public DmcOutputStream(OutputStream os, boolean mode) {
        super(os);
        this.isFile = mode;
    }

    @Override
    public boolean isFile() {
        return this.isFile;
    }

    @Override
    public void writeAttributeID(DmcAttributeInfo ai) throws Exception {
        super.writeShort(ai.id);
    }

    @Override
    public void writeAttributeCount(int count) throws Exception {
        super.writeShort(count);
    }

    @Override
    public void writeValueCount(int size) throws Exception {
        if (size < 0) {
            throw new IllegalStateException("Can't encode a negative integer value count.");
        }
        if (size > Short.MAX_VALUE) {
            super.writeShort((short)(size >> 16 | 0x8000));
            super.writeShort(size);
        } else {
            super.writeShort(size);
        }
    }

    @Override
    public void writeBytes(byte[] v) throws Exception {
        super.write(v);
    }
}

