/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.util;

import java.io.DataInputStream;
import java.io.InputStream;
import org.dmd.dmc.DmcAttribute;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcFilter;
import org.dmd.dmc.DmcInputStreamIF;
import org.dmd.dmc.DmcObject;
import org.dmd.dmc.DmcObjectName;
import org.dmd.dmc.DmcOmni;
import org.dmd.dmc.types.DmcTypeNamedObjectREF;
import org.dmd.dms.ClassDefinition;
import org.dmd.dms.SchemaManager;
import org.dmd.dms.generated.types.ClassDefinitionREF;
import org.dmd.dmw.DmwWrapper;
import org.dmd.util.exceptions.DebugInfo;
import org.dmd.util.formatting.PrintfFormat;

public class DmcTraceableInputStream
implements DmcInputStreamIF {
    SchemaManager schema;
    DataInputStream dis;
    boolean calledFrom;
    PrintfFormat format;

    public DmcTraceableInputStream(InputStream is, SchemaManager sm, boolean cf, int padding) {
        this.dis = new DataInputStream(is);
        this.schema = sm;
        this.calledFrom = cf;
        this.format = new PrintfFormat("%-" + padding + "s");
    }

    @Override
    public DmcAttribute<?> getAttributeInstance(DmcAttributeInfo ai) throws Exception {
        return this.schema.getAttributeInstance(ai.id);
    }

    @Override
    public DmcAttribute<?> getAttributeInstance(Integer id) throws Exception {
        return this.schema.getAttributeInstance(id);
    }

    @Override
    public void resolveReferences(DmcTypeNamedObjectREF<?, ?> attr) throws Exception {
        attr.resolveReferences(this.schema);
    }

    @Override
    public int available() throws Exception {
        return this.dis.available();
    }

    @Override
    public int readAttributeCount() throws Exception {
        short rc = this.dis.readShort();
        if (this.calledFrom) {
            System.out.print(this.format.sprintf(DebugInfo.getShortWhereWeWereCalledFrom()) + " ");
        }
        System.out.println(" # attr: " + rc);
        return rc;
    }

    @Override
    public int readAttributeID() throws Exception {
        short id = this.dis.readShort();
        DmcAttributeInfo ai = DmcOmni.instance().getInfo(Integer.valueOf(id));
        if (this.calledFrom) {
            System.out.print(this.format.sprintf(DebugInfo.getShortWhereWeWereCalledFrom()) + " ");
        }
        if (ai == null) {
            System.out.println(" attrid: " + id + "  ???");
        } else {
            System.out.println(" attrid: " + ai.id + "  " + ai.name);
        }
        return id;
    }

    @Override
    public boolean readBoolean() throws Exception {
        boolean rc = this.dis.readBoolean();
        if (this.calledFrom) {
            System.out.print(this.format.sprintf(DebugInfo.getShortWhereWeWereCalledFrom()) + " ");
        }
        System.out.println("boolean: " + rc);
        return rc;
    }

    @Override
    public byte readByte() throws Exception {
        byte rc = this.dis.readByte();
        if (this.calledFrom) {
            System.out.print(this.format.sprintf(DebugInfo.getShortWhereWeWereCalledFrom()) + " ");
        }
        System.out.println("   byte: " + rc);
        return rc;
    }

    @Override
    public int readBytes(byte[] b) throws Exception {
        int rc = this.dis.read(b);
        if (this.calledFrom) {
            System.out.print(this.format.sprintf(DebugInfo.getShortWhereWeWereCalledFrom()) + " ");
        }
        System.out.println("  bytes: " + rc + " (bytes not actually shown)");
        return rc;
    }

    @Override
    public char readChar() throws Exception {
        char rc = this.dis.readChar();
        if (this.calledFrom) {
            System.out.print(this.format.sprintf(DebugInfo.getShortWhereWeWereCalledFrom()) + " ");
        }
        System.out.println("   char: " + rc);
        return rc;
    }

    @Override
    public double readDouble() throws Exception {
        double rc = this.dis.readDouble();
        if (this.calledFrom) {
            System.out.print(this.format.sprintf(DebugInfo.getShortWhereWeWereCalledFrom()) + " ");
        }
        System.out.println(" double: " + rc);
        return rc;
    }

    @Override
    public float readFloat() throws Exception {
        float rc = this.dis.readFloat();
        if (this.calledFrom) {
            System.out.print(this.format.sprintf(DebugInfo.getShortWhereWeWereCalledFrom()) + " ");
        }
        System.out.println(" float: " + rc);
        return rc;
    }

    @Override
    public int readInt() throws Exception {
        int rc = this.dis.readInt();
        if (this.calledFrom) {
            System.out.print(this.format.sprintf(DebugInfo.getShortWhereWeWereCalledFrom()) + " ");
        }
        System.out.println("    int: " + rc);
        return rc;
    }

    @Override
    public long readLong() throws Exception {
        long rc = this.dis.readLong();
        if (this.calledFrom) {
            System.out.print(this.format.sprintf(DebugInfo.getShortWhereWeWereCalledFrom()) + " ");
        }
        System.out.println("   long: " + rc);
        return rc;
    }

    @Override
    public int readValueCount() throws Exception {
        short rc = this.dis.readShort();
        if (this.calledFrom) {
            System.out.print(this.format.sprintf(DebugInfo.getShortWhereWeWereCalledFrom()) + " ");
        }
        System.out.println(" # vals: " + rc);
        return rc;
    }

    @Override
    public short readShort() throws Exception {
        short rc = this.dis.readShort();
        if (this.calledFrom) {
            System.out.print(this.format.sprintf(DebugInfo.getShortWhereWeWereCalledFrom()) + " ");
        }
        System.out.println("  short: " + rc);
        return rc;
    }

    @Override
    public String readUTF() throws Exception {
        String rc = this.dis.readUTF();
        if (this.calledFrom) {
            System.out.print(this.format.sprintf(DebugInfo.getShortWhereWeWereCalledFrom()) + " ");
        }
        System.out.println("    utf: " + rc);
        return rc;
    }

    @Override
    public DmcAttribute<?> getAttributeInstance() throws Exception {
        short id = this.dis.readShort();
        DmcAttribute<?> rc = this.getAttributeInstance(Integer.valueOf(id));
        if (this.calledFrom) {
            System.out.print(this.format.sprintf(DebugInfo.getShortWhereWeWereCalledFrom()) + " ");
        }
        System.out.println(" attrid: " + id + "  " + rc.getAttributeInfo().name + "  " + rc.getClass().getName());
        return rc;
    }

    @Override
    public DmcObjectName getNameValueInstance() throws Exception {
        short id = this.dis.readShort();
        DmcObjectName rc = this.schema.getNameValueInstance(Integer.valueOf(id));
        if (this.calledFrom) {
            System.out.print(this.format.sprintf(DebugInfo.getShortWhereWeWereCalledFrom()) + " ");
        }
        System.out.println(" attrid: " + id + "  name value:  " + rc.getClass().getName());
        return rc;
    }

    @Override
    public DmcFilter getFilterValueInstance() throws Exception {
        DebugInfo.debug("NOT IMPLEMENTED YET");
        return null;
    }

    @Override
    public DmcObject getDMOInstance(DmcInputStreamIF dis) throws Exception {
        DmcObject rc = null;
        int classCount = dis.readInt();
        int classID = dis.readInt();
        ClassDefinition cd = this.schema.isClass(classID);
        if (cd == null) {
            throw new IllegalStateException("Unknown class ID: " + classID + " ensure that you have loaded the required schemas.");
        }
        DmwWrapper wrapper = null;
        try {
            wrapper = cd.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        rc = wrapper == null ? cd.newDMOInstance() : wrapper.getDmcObject();
        if (classCount > 1) {
            for (int i = 1; i < classCount; ++i) {
                classID = dis.readInt();
                cd = this.schema.isClass(classID);
                rc.addAux(new ClassDefinitionREF(cd.getDMO()));
            }
        }
        return rc;
    }
}

