/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.util;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.dmd.dmc.DmcAttributeInfo;
import org.dmd.dmc.DmcOutputStreamIF;
import org.dmd.util.exceptions.DebugInfo;
import org.dmd.util.formatting.PrintfFormat;

public class DmcTraceableOutputStream
implements DmcOutputStreamIF {
    boolean isFile;
    DataOutputStream dos;
    boolean calledFrom;
    PrintfFormat format;

    public DmcTraceableOutputStream(OutputStream os, boolean cf, int padding) {
        this.dos = new DataOutputStream(os);
        this.calledFrom = cf;
        this.format = new PrintfFormat("%-" + padding + "s");
        this.isFile = true;
    }

    public DmcTraceableOutputStream(OutputStream os, boolean cf, int padding, boolean mode) {
        this.dos = new DataOutputStream(os);
        this.calledFrom = cf;
        this.format = new PrintfFormat("%-" + padding + "s");
        this.isFile = mode;
    }

    @Override
    public boolean isFile() {
        return this.isFile;
    }

    @Override
    public void writeAttributeID(DmcAttributeInfo ai) throws Exception {
        this.dos.writeShort(ai.id);
        if (this.calledFrom) {
            System.out.print(this.format.sprintf(DebugInfo.getShortWhereWeWereCalledFrom()) + " ");
        }
        System.out.println(" attrid: " + ai.id + "  " + ai.name);
    }

    @Override
    public void writeAttributeCount(int count) throws Exception {
        this.dos.writeShort(count);
        if (this.calledFrom) {
            System.out.print(this.format.sprintf(DebugInfo.getShortWhereWeWereCalledFrom()) + " ");
        }
        System.out.println(" # attr: " + count);
    }

    @Override
    public void writeValueCount(int size) throws Exception {
        this.dos.writeShort(size);
        if (this.calledFrom) {
            System.out.print(this.format.sprintf(DebugInfo.getShortWhereWeWereCalledFrom()) + " ");
        }
        System.out.println(" # vals: " + size);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.dos.writeBoolean(v);
        if (this.calledFrom) {
            System.out.print(this.format.sprintf(DebugInfo.getShortWhereWeWereCalledFrom()) + " ");
        }
        System.out.println("boolean: " + v);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.dos.writeByte(v);
        if (this.calledFrom) {
            System.out.print(this.format.sprintf(DebugInfo.getShortWhereWeWereCalledFrom()) + " ");
        }
        System.out.println("    int: " + v);
    }

    @Override
    public void writeBytes(String v) throws IOException {
        this.dos.writeBytes(v);
        if (this.calledFrom) {
            System.out.print(this.format.sprintf(DebugInfo.getShortWhereWeWereCalledFrom()) + " ");
        }
        System.out.println(" string: " + v);
    }

    @Override
    public void writeBytes(byte[] v) throws Exception {
        this.dos.write(v);
        if (this.calledFrom) {
            System.out.print(this.format.sprintf(DebugInfo.getShortWhereWeWereCalledFrom()) + " ");
        }
        System.out.println("  bytes: (some bytes that I'm not gonna show)");
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.dos.writeChar(v);
        if (this.calledFrom) {
            System.out.print(this.format.sprintf(DebugInfo.getShortWhereWeWereCalledFrom()) + " ");
        }
        System.out.println("   char: " + v);
    }

    @Override
    public void writeChars(String v) throws IOException {
        this.dos.writeChars(v);
        if (this.calledFrom) {
            System.out.print(this.format.sprintf(DebugInfo.getShortWhereWeWereCalledFrom()) + " ");
        }
        System.out.println("  chars: " + v);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.dos.writeDouble(v);
        if (this.calledFrom) {
            System.out.print(this.format.sprintf(DebugInfo.getShortWhereWeWereCalledFrom()) + " ");
        }
        System.out.println("double: " + v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.dos.writeFloat(v);
        if (this.calledFrom) {
            System.out.print(this.format.sprintf(DebugInfo.getShortWhereWeWereCalledFrom()) + " ");
        }
        System.out.println("  float: " + v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.dos.writeInt(v);
        if (this.calledFrom) {
            System.out.print(this.format.sprintf(DebugInfo.getShortWhereWeWereCalledFrom()) + " ");
        }
        System.out.println("integer: " + v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.dos.writeLong(v);
        if (this.calledFrom) {
            System.out.print(this.format.sprintf(DebugInfo.getShortWhereWeWereCalledFrom()) + " ");
        }
        System.out.println("   long: " + v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.dos.writeShort(v);
        if (this.calledFrom) {
            System.out.print(this.format.sprintf(DebugInfo.getShortWhereWeWereCalledFrom()) + " ");
        }
        System.out.println("  short: " + v);
    }

    @Override
    public void writeUTF(String v) throws IOException {
        this.dos.writeUTF(v);
        if (this.calledFrom) {
            System.out.print(this.format.sprintf(DebugInfo.getShortWhereWeWereCalledFrom()) + " ");
        }
        System.out.println("    utf: " + v);
    }
}

