/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.util.HashSet;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;
import org.dmd.util.ManagedFileWriter;
import org.dmd.util.UtilityOptions;

public class FileUpdateManager {
    static FileUpdateManager instance;
    PrintStream progressStream = null;
    PrintStream errorStream;
    String fileHeader;
    String outFolder = null;
    boolean checkFileWhenComplete = false;
    int filesReplaced;
    int filesCreated;
    int filesDeleted;
    boolean deleteFiles = true;
    String lastFolder = null;
    TreeMap<String, HashSet<String>> directoryTracker;

    protected FileUpdateManager() {
    }

    public static FileUpdateManager instance() {
        if (instance == null) {
            instance = new FileUpdateManager();
        }
        return instance;
    }

    public void deleteFiles(boolean f) {
        this.deleteFiles = f;
    }

    public void reportProgress(PrintStream ps) {
        this.progressStream = ps;
    }

    public void reportErrors(PrintStream ps) {
        this.errorStream = ps;
    }

    public void fileHeader(String fh) {
        this.fileHeader = fh;
    }

    public void generationStarting() {
        this.directoryTracker = new TreeMap();
        this.filesReplaced = 0;
        this.filesCreated = 0;
        this.filesDeleted = 0;
    }

    public void generationComplete() {
        if (this.directoryTracker == null) {
            throw new IllegalStateException("The generationStarting() method must be called before calling generationComplete()");
        }
        for (String outdir : this.directoryTracker.keySet()) {
            File dir = new File(outdir);
            File[] files = dir.listFiles();
            HashSet<String> genFiles = this.directoryTracker.get(outdir);
            for (File file : files) {
                if (!file.getName().endsWith(".java") || genFiles.contains(file.getName())) continue;
                if (this.deleteFiles) {
                    if (!file.delete()) {
                        this.reportError("    Could not delete obsolete file: " + file.getAbsolutePath());
                    }
                    this.reportProgress("    Removing obsolete file: " + file.getAbsolutePath());
                    ++this.filesDeleted;
                    continue;
                }
                this.reportProgress("    This file may be obsolete: " + file.getAbsolutePath());
            }
        }
        this.reportProgress("\n");
        this.reportProgress("Files created:  " + this.filesCreated);
        this.reportProgress("Files replaced: " + this.filesReplaced);
        this.reportProgress("Files deleted:  " + this.filesDeleted);
    }

    public ManagedFileWriter getWriter(String of, String fn) throws IOException {
        if (this.directoryTracker == null) {
            throw new IllegalStateException("You must call the generationStarting() method before using the FileUpdateManager.");
        }
        this.outFolder = of;
        String outFileName = this.outFolder + "/" + fn;
        File outFile = new File(outFileName);
        this.checkFileWhenComplete = false;
        this.addtoTracker(this.outFolder, fn);
        if (outFile.exists()) {
            outFileName = this.outFolder + "/NEW" + fn;
            this.checkFileWhenComplete = true;
        } else {
            this.reportProgress("    Generating: " + outFile.getAbsolutePath());
            ++this.filesCreated;
        }
        ManagedFileWriter rc = new ManagedFileWriter((Writer)new FileWriter(outFileName), fn);
        if (this.fileHeader != null) {
            rc.write(this.fileHeader);
        }
        return rc;
    }

    void reportProgress(String message) {
        if (UtilityOptions.instance().quietProgress()) {
            return;
        }
        if (this.lastFolder == null) {
            if (this.progressStream != null) {
                this.progressStream.println("");
            }
        } else if (!this.lastFolder.equals(this.outFolder) && this.progressStream != null) {
            this.progressStream.println("");
        }
        if (this.progressStream != null) {
            this.progressStream.println(message);
        }
    }

    void reportError(String message) {
        if (this.errorStream != null) {
            this.errorStream.println(message);
        }
    }

    void addtoTracker(String od, String fn) {
        HashSet<String> set = this.directoryTracker.get(od);
        if (set == null) {
            set = new HashSet();
            this.directoryTracker.put(od, set);
        }
        set.add(fn);
    }

    public void fileClosed(ManagedFileWriter mfw) {
        if (this.checkFileWhenComplete) {
            File existing = new File(this.outFolder + "/" + mfw.fileName);
            File newgen = new File(this.outFolder + "/NEW" + mfw.fileName);
            try {
                if (!FileUtils.contentEquals((File)existing, (File)newgen)) {
                    FileUtils.copyFile((File)newgen, (File)existing);
                    ++this.filesReplaced;
                    this.reportProgress("     Replacing: " + existing.getAbsolutePath());
                }
                if (!newgen.delete()) {
                    this.reportError("    Could not delete temporary file: " + newgen.getAbsolutePath());
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("File comparison failed.", e);
            }
        }
        this.fileHeader = null;
        this.lastFolder = this.outFolder;
    }
}

