/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.util.codegen;

import java.util.TreeMap;
import org.dmd.util.codegen.ImportStatement;
import org.dmd.util.exceptions.DebugInfo;
import org.dmd.util.formatting.PrintfFormat;

public class ImportManager {
    TreeMap<String, ImportStatement> imports = new TreeMap();
    int longestImport = 0;
    static TreeMap<String, ImportStatement> staticImports = new TreeMap();
    static int staticLongestImport;

    public static void resetStatic() {
        staticImports = new TreeMap();
        staticLongestImport = 0;
    }

    public static void addImportStatic(String cn, String reason) {
        staticImports.put(cn, new ImportStatement(cn, reason));
        if (cn.length() > staticLongestImport) {
            staticLongestImport = cn.length();
        }
    }

    public static String getFormattedImportsStatic() {
        StringBuffer sb = new StringBuffer();
        int padding = staticLongestImport + 17;
        PrintfFormat format = new PrintfFormat("%-" + padding + "s");
        sb.append("// Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        sb.append("// " + DebugInfo.getWhereWeWereCalledFrom() + "\n");
        for (ImportStatement i : staticImports.values()) {
            sb.append(format.sprintf("import " + i.className + ";") + "// " + i.reason + "\n");
        }
        return sb.toString();
    }

    public void reset() {
        this.imports = new TreeMap();
        this.longestImport = 0;
    }

    public void addImportsFrom(ImportManager im) {
        for (ImportStatement is : im.imports.values()) {
            if (is.className.length() > this.longestImport) {
                this.longestImport = is.className.length();
            }
            this.imports.put(is.className, is);
        }
    }

    public void addImport(String cn, String reason) {
        if (this.imports.get(cn) != null) {
            return;
        }
        this.imports.put(cn, new ImportStatement(cn, reason + " - " + DebugInfo.getShortWhereWeWereCalledFrom()));
        if (cn.length() > this.longestImport) {
            this.longestImport = cn.length();
        }
    }

    public String getFormattedImports() {
        StringBuffer sb = new StringBuffer();
        int padding = this.longestImport + 17;
        PrintfFormat format = new PrintfFormat("%-" + padding + "s");
        sb.append("// Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        sb.append("// " + DebugInfo.getWhereWeWereCalledFrom() + "\n");
        for (ImportStatement i : this.imports.values()) {
            sb.append(format.sprintf("import " + i.className + ";") + "// " + i.reason + "\n");
        }
        sb.append("\n");
        return sb.toString();
    }
}

