/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.util.codegen;

import java.io.IOException;
import java.util.ArrayList;
import java.util.TreeSet;
import org.dmd.dmc.DmcNameClashException;
import org.dmd.dmc.DmcValueException;
import org.dmd.dmg.generated.dmo.DmgConfigDMO;
import org.dmd.dms.ClassDefinition;
import org.dmd.dms.DSDefinitionModule;
import org.dmd.dms.SchemaManager;
import org.dmd.util.FileUpdateManager;
import org.dmd.util.ManagedFileWriter;
import org.dmd.util.codegen.ImportManager;
import org.dmd.util.exceptions.DebugInfo;

public class InitializationInterfaceManager {
    public static final String DEF_INT_SUFFIX = "DefinitionsIF";
    public static final String CONFIG_LOADER = "ConfigLoader";
    public static final String INITIALIZE = "initialize";
    private DmgConfigDMO config;
    private DSDefinitionModule dslDef;
    private SchemaManager sm;
    private ImportManager imports;
    private ImportManager loaderImports;
    private ImportManager initializationImports;
    private TreeSet<String> initializationInterfaces;
    private TreeSet<String> requiredInterfaces = new TreeSet();
    private ArrayList<DSDefinitionModule> allBaseDefinitions;

    public InitializationInterfaceManager(DmgConfigDMO config, DSDefinitionModule dslDef, SchemaManager sm) throws DmcNameClashException, DmcValueException {
        this.config = config;
        this.dslDef = dslDef;
        this.sm = sm;
        this.imports = new ImportManager();
        this.loaderImports = new ImportManager();
        this.initializationImports = new ImportManager();
        this.initializationInterfaces = new TreeSet();
        this.requiredInterfaces = new TreeSet();
        this.allBaseDefinitions = new ArrayList();
        ClassDefinition ddmClass = sm.isClass(dslDef.getName().getNameString());
        this.loaderImports.addImport(ddmClass.getDmeImport(), "The module type we load");
    }

    public ImportManager getInitializationImports() {
        return this.initializationImports;
    }

    public String getFormattedInitializationInterfaces() {
        if (this.initializationInterfaces.size() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (String s : this.initializationInterfaces) {
            if (sb.length() == 0) {
                sb.append(s);
                continue;
            }
            sb.append(", " + s);
        }
        return ", " + sb.toString() + " ";
    }

    public void addInterfaceFor(DSDefinitionModule ddm) throws DmcNameClashException, DmcValueException {
        this.imports.addImport(ddm.getGlobalInterfaceImport(), "Interface for " + ddm.getName() + " definitions");
        this.loaderImports.addImport(ddm.getDefinitionsInterfaceImport(), "Interface for " + ddm.getName() + " definitions");
        this.initializationImports.addImport(ddm.getDefinitionsInterfaceImport(), "Interface for " + ddm.getName() + " definitions");
        this.initializationInterfaces.add(ddm.getDefinitionsInterfaceName());
        this.requiredInterfaces.add(ddm.getGlobalInterfaceName());
        ClassDefinition baseDefClass = this.sm.isClass(ddm.getBaseDefinition().getName().getNameString());
        this.loaderImports.addImport(baseDefClass.getDmeImport(), "One of our base definition types");
        this.allBaseDefinitions.add(ddm);
    }

    public void generateInitializationInterface(String dir) throws IOException {
        ManagedFileWriter out = FileUpdateManager.instance().getWriter(dir, this.dslDef.getName() + DEF_INT_SUFFIX + ".java");
        out.write("package " + this.config.getGenPackage() + ".generated.dsd;\n\n");
        out.write(this.imports.getFormattedImports());
        out.write("\n");
        out.write("// Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("public interface " + this.dslDef.getName() + DEF_INT_SUFFIX + " extends ");
        StringBuffer sb = new StringBuffer();
        for (String s : this.requiredInterfaces) {
            if (sb.length() == 0) {
                sb.append(s);
                continue;
            }
            sb.append(", " + s);
        }
        out.write(sb.toString() + " {\n\n");
        out.write("}\n\n");
        out.close();
    }

    public void generateConfigLoader(String dir) throws IOException {
        ManagedFileWriter out = FileUpdateManager.instance().getWriter(dir, this.dslDef.getName() + CONFIG_LOADER + ".java");
        out.write("package " + this.config.getGenPackage() + ".generated.dsd;\n\n");
        this.loaderImports.addImport("java.io.IOException", "For exceptions");
        this.loaderImports.addImport("java.util.Iterator", "Iteration over definitions");
        this.loaderImports.addImport("org.dmd.dmc.DmcNameClashException", "For exceptions");
        this.loaderImports.addImport("org.dmd.dmc.DmcValueException", "For exceptions");
        this.loaderImports.addImport("org.dmd.dmc.DmcValueExceptionSet", "For exceptions");
        this.loaderImports.addImport("org.dmd.dmc.rules.DmcRuleExceptionSet", "For exceptions");
        this.loaderImports.addImport("org.dmd.util.exceptions.ResultException", "For exceptions");
        this.loaderImports.addImport("org.dmd.dmc.DmcOmni", "Back reference tracking");
        this.loaderImports.addImport("org.dmd.util.parsing.ConfigLocation", "Where a module came from");
        out.write(this.loaderImports.getFormattedImports());
        out.write("\n");
        out.write("// Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        out.write("public class " + this.dslDef.getName() + "ConfigLoader extends " + this.dslDef.getName() + "GenUtility {\n");
        out.write("    private " + this.dslDef.getName() + "DefinitionManager definitionManager;\n");
        out.write("    \n");
        out.write("    public " + this.dslDef.getName() + CONFIG_LOADER + "() {\n");
        out.write("        // Allows us to follow back references\n");
        out.write("        DmcOmni.instance().backRefTracking(true);\n");
        out.write("    }\n");
        out.write("    \n");
        out.write("    /**\n");
        out.write("     * Load all modules from the specified directory.\n");
        out.write("     * @param srcdir the directory from which to load modules\n");
        out.write("     */\n");
        out.write("    public void loadAllModules(String srcdir) throws ResultException, DmcValueException, IOException, DmcRuleExceptionSet, DmcNameClashException, DmcValueExceptionSet {\n");
        out.write("        String[] args = { \"-srcdir\", srcdir };\n");
        out.write("                \n");
        out.write("        super.run(args);\n");
        out.write("    }\n");
        out.write("    \n");
        out.write("    /**\n");
        out.write("     * Load the specified module and all of its dependencies.\n");
        out.write("     * @param srcdir the directory from which to load modules\n");
        out.write("     * @param module the name of the module (without the file extension)\n");
        out.write("     */\n");
        out.write("    public void loadModule(String srcdir, String module) throws ResultException, DmcValueException, IOException, DmcRuleExceptionSet, DmcNameClashException, DmcValueExceptionSet {\n");
        out.write("        String[] args = { \"-srcdir\", srcdir , \"-targets\", module};\n");
        out.write("        \n");
        out.write("        super.run(args);\n");
        out.write("    }\n");
        out.write("\n");
        out.write("    /**\n");
        out.write("     * Adds a directory that will be recursively searched for modules.\n");
        out.write("     * @param dir the directory to be searched\n");
        out.write("     */\n");
        out.write("    public void addSrcDir(String dir){\n");
        out.write("        searchPaths.add(dir);\n");
        out.write("    }\n");
        out.write("    \n");
        out.write("    public " + this.dslDef.getName() + "DefinitionManager definitionManager() {\n");
        out.write("        return(definitionManager);\n");
        out.write("    }\n");
        out.write("\n");
        out.write("    @Override\n");
        out.write("    public void parsingComplete(" + this.dslDef.getName() + " module, ConfigLocation location, " + this.dslDef.getName() + "DefinitionManager definitions) throws ResultException {\n");
        out.write("        // This is called once all required modules have been parsed\n");
        out.write("        // If you need to insert other definitions prior to object resolution, this is where you can do it\n");
        out.write("        \n");
        out.write("        // We hold on to the definition manager so that it can be accessed\n");
        out.write("        definitionManager = definitions;\n");
        out.write("    }\n");
        out.write("\n");
        out.write("    @Override\n");
        out.write("    public void objectResolutionComplete(" + this.dslDef.getName() + " module, ConfigLocation location, " + this.dslDef.getName() + "DefinitionManager definitions) throws ResultException {\n");
        out.write("        // This is called when the object resolution phase has completed\n");
        out.write("    }\n");
        out.write("\n");
        out.write("    @Override\n");
        out.write("    public void generate(" + this.dslDef.getName() + " module, ConfigLocation location, " + this.dslDef.getName() + "DefinitionManager definitions) throws ResultException, IOException {\n");
        out.write("        initializeDefinitions();\n");
        out.write("    }\n");
        out.write("\n");
        out.write("    @Override\n");
        out.write("    public void generate(" + this.dslDef.getName() + "DefinitionManager definitions) throws ResultException, IOException {\n");
        out.write("        initializeDefinitions();\n");
        out.write("    }\n");
        out.write("\n");
        out.write("    @Override\n");
        out.write("    public void displayHelp() {\n");
        out.write("        // This is not required in this context\n");
        out.write("    }\n");
        out.write("    \n");
        out.write("    private void initializeDefinitions() throws ResultException {\n");
        for (int i = this.allBaseDefinitions.size() - 1; i >= 0; --i) {
            DSDefinitionModule ddm = this.allBaseDefinitions.get(i);
            String base = ddm.getBaseDefinition().getName().getNameString();
            out.write("        Iterator<" + base + "> " + base + "IT = definitionManager.getAll" + base + "();\n");
            out.write("        while(" + base + "IT.hasNext()) {\n");
            out.write("            " + base + " def = " + base + "IT.next();\n");
            out.write("            def.initialize((" + ddm.getDefinitionsInterfaceName() + ")definitionManager);\n");
            out.write("        }\n");
        }
        out.write("    }\n");
        out.write("}\n\n");
        out.close();
    }
}

