/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.util.codegen;

import java.util.ArrayList;
import org.dmd.util.codegen.MemberStatement;
import org.dmd.util.exceptions.DebugInfo;
import org.dmd.util.formatting.PrintfFormat;

public class MemberManager {
    ArrayList<MemberStatement> members = new ArrayList();
    int longestType;
    int longestName;
    int longestConstruction;

    public void addSpacer() {
        this.members.add(new MemberStatement());
    }

    public void addMember(String t, String n, String r) {
        this.members.add(new MemberStatement(t, n, r));
        if (t.length() > this.longestType) {
            this.longestType = t.length();
        }
        if (n.length() > this.longestName) {
            this.longestName = n.length();
        }
    }

    public void addMember(String t, String n, String c, String r) {
        this.members.add(new MemberStatement(t, n, c, r));
        if (t.length() > this.longestType) {
            this.longestType = t.length();
        }
        if (n.length() > this.longestName) {
            this.longestName = n.length();
        }
        if (c.length() > this.longestConstruction) {
            this.longestConstruction = c.length();
        }
    }

    public String getFormattedMembers() {
        StringBuffer sb = new StringBuffer();
        sb.append("    // Generated from: " + DebugInfo.getWhereWeAreNow() + "\n");
        sb.append("    // " + DebugInfo.getWhereWeWereCalledFrom() + "\n");
        int tpadding = this.longestType + 4;
        int npadding = this.longestName + 4;
        int cpadding = this.longestConstruction + 6;
        PrintfFormat tformat = new PrintfFormat("%-" + tpadding + "s");
        PrintfFormat nformat = new PrintfFormat("%-" + npadding + "s");
        PrintfFormat cformat = new PrintfFormat("%-" + cpadding + "s");
        for (MemberStatement mem : this.members) {
            sb.append("    " + tformat.sprintf(mem.type));
            sb.append(nformat.sprintf(mem.name));
            sb.append(cformat.sprintf(mem.construction));
            sb.append("// " + mem.reason + "\n");
        }
        return sb.toString();
    }
}

