/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.util.count;

import org.dmd.util.formatting.PrintfFormat;

public class CodeCountInfo {
    public String packageName;
    public String fileName;
    public int codeCount;
    public int blankCount;
    public int importCount;
    public int commentCount;
    public int totalLines;
    boolean auto;

    CodeCountInfo(String fullName, String n) {
        this.fileName = new String(n);
        this.codeCount = 0;
        this.blankCount = 0;
        this.importCount = 0;
        this.commentCount = 0;
        this.totalLines = 0;
        this.auto = false;
        int generatedPos = fullName.indexOf("generated");
        if (generatedPos != -1) {
            this.auto = true;
        }
    }

    public String formatInfo(PrintfFormat nameFormat, PrintfFormat numFormat) {
        StringBuffer sb = new StringBuffer();
        sb.append(nameFormat.sprintf(this.fileName));
        sb.append(numFormat.sprintf(this.codeCount));
        sb.append(numFormat.sprintf(this.commentCount));
        sb.append(numFormat.sprintf(this.importCount));
        sb.append(numFormat.sprintf(this.blankCount));
        sb.append(numFormat.sprintf(this.totalLines));
        return sb.toString();
    }

    public void setPackage(String s) {
        StringBuffer sb = new StringBuffer(s);
        sb.replace(0, 7, "");
        while (sb.charAt(0) == ' ') {
            sb.replace(0, 1, "");
        }
        sb.setLength(sb.length() - 1);
        this.packageName = new String(sb.toString());
    }
}

