/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.util.count;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Iterator;
import java.util.TreeMap;
import org.dmd.util.BooleanVar;
import org.dmd.util.count.CodeCountInfo;
import org.dmd.util.exceptions.ResultSet;
import org.dmd.util.formatting.PrintfFormat;
import org.dmd.util.parsing.CommandLine;
import org.dmd.util.parsing.StringArrayList;

public class CodeCountMain {
    StringBuffer help;
    TreeMap<String, TreeMap<String, CodeCountInfo>> packages;
    PrintfFormat nameFormat;
    PrintfFormat totalFormat;
    PrintfFormat numFormat;
    PrintfFormat colFormat;
    int longestName;
    BooleanVar helpFlag = new BooleanVar();
    BooleanVar recursiveFlag = new BooleanVar();
    StringBuffer ofn = new StringBuffer("");
    StringBuffer workspace = new StringBuffer();
    StringBuffer inDir = new StringBuffer();
    StringBuffer outDir = new StringBuffer("./out");
    StringArrayList skip = new StringArrayList();
    BufferedWriter out;

    public void run(String[] args) {
        CommandLine cl = new CommandLine();
        ResultSet rs = new ResultSet();
        this.nameFormat = new PrintfFormat("%-30s");
        this.numFormat = new PrintfFormat("%10d");
        this.colFormat = new PrintfFormat("%10s");
        this.longestName = 0;
        this.packages = new TreeMap();
        this.out = null;
        this.help = new StringBuffer();
        this.help.append("count -h -workspace -id -of -r -skip\n\n");
        this.help.append("The code count tool provides a simple code count mechansism. It indicates the\n");
        this.help.append("number of source, comment, import and blank lines in a set of Java files\n");
        this.help.append("and how many files are auto generated.\n");
        this.help.append("\n");
        this.help.append("-h          Dumps the help information\n");
        this.help.append("\n");
        this.help.append("-workspace  Indicates the workspace prefix.\n");
        this.help.append("\n");
        this.help.append("-id         Indicates the directory beneath the workspace at which parsing should start. \n");
        this.help.append("\n");
        this.help.append("-of         The output file name.\n");
        this.help.append("\n");
        this.help.append("-r          Indicates that you want to recurse through all subdirectories. \n");
        this.help.append("\n");
        this.help.append("-skip      (suffix) Indicates that you want to skip subdirectories that end with the \n");
        this.help.append("           specified suffix.\n");
        this.help.append("\n");
        this.help.append("\n");
        cl.addOption("-h", this.helpFlag, "Dumps the help message.");
        cl.addOption("-o", this.ofn, "Output file name.");
        cl.addOption("-workspace", this.workspace, "The workspace prefix");
        cl.addOption("-indir", this.inDir, "The input directory");
        cl.addOption("-of", this.outDir, "The output directory");
        cl.addOption("-r", this.recursiveFlag, "Recurses through all subdirectories.");
        cl.addOption("-skip", this.skip, "Skips the specified directory.");
        cl.parseArgs(args);
        if (this.ofn.length() > 0) {
            try {
                this.out = new BufferedWriter(new FileWriter(this.ofn.toString()));
            }
            catch (IOException e) {
                System.out.println("IO Error:\n" + e);
                System.exit(1);
            }
        }
        if (args.length == 0 || this.helpFlag.booleanValue()) {
            this.println(this.help.toString());
            System.exit(0);
        }
        if (this.workspace.length() == 0) {
            System.err.println("You must specify the -workspace argument");
            System.exit(1);
        }
        String startDir = this.workspace.toString();
        if (this.inDir.length() > 0) {
            startDir = startDir + File.separator + this.inDir.toString();
        }
        this.readDirectory(rs, startDir);
        this.nameFormat = new PrintfFormat("%-" + this.longestName + "s");
        this.totalFormat = new PrintfFormat("%" + this.longestName + "s");
        this.dumpInfo();
        this.println(rs.toString());
        if (this.out != null) {
            try {
                System.out.println("Output written to " + this.ofn.toString());
                this.out.close();
            }
            catch (IOException e) {
                System.out.println("IO Error:\n" + e);
                System.exit(1);
            }
        }
        System.exit(0);
    }

    boolean readDirectory(ResultSet rs, String dirName) {
        boolean rc = true;
        File codeDir = new File(dirName);
        if (this.skip.size() > 0) {
            for (int i = 0; i < this.skip.size(); ++i) {
                if (!dirName.endsWith((String)this.skip.get(i))) continue;
                System.out.println("Skipping directory: " + dirName);
                return true;
            }
        }
        if (!codeDir.exists()) {
            rs.addResult(4, "Couldn't access code directory: " + dirName);
            rc = false;
        } else {
            String fullname = null;
            File currFile = null;
            String[] dirList = codeDir.list();
            for (int i = 0; i < dirList.length; ++i) {
                fullname = codeDir.getAbsolutePath() + File.separatorChar + dirList[i];
                currFile = new File(fullname);
                if (currFile.isDirectory()) {
                    if (!this.recursiveFlag.booleanValue() || this.readDirectory(rs, fullname)) continue;
                    rc = false;
                    continue;
                }
                if (!fullname.endsWith(".java") || this.parseFile(rs, fullname, dirList[i])) continue;
                rc = false;
                break;
            }
        }
        return rc;
    }

    boolean parseFile(ResultSet rs, String fullname, String justname) {
        boolean rc = true;
        CodeCountInfo info = new CodeCountInfo(fullname, justname);
        boolean codeFound = false;
        if (justname.length() > this.longestName) {
            this.longestName = justname.length();
        }
        try {
            String tmpstr;
            LineNumberReader in = new LineNumberReader(new FileReader(fullname));
            while ((tmpstr = in.readLine()) != null) {
                String str = tmpstr.trim();
                if (str.length() == 0) {
                    ++info.blankCount;
                    continue;
                }
                if (str.startsWith("import")) {
                    ++info.importCount;
                    codeFound = true;
                    continue;
                }
                if (str.startsWith("package") && !codeFound) {
                    ++info.importCount;
                    info.setPackage(str);
                    continue;
                }
                if (str.lastIndexOf("/*") != -1) {
                    if (this.processBlock(str, in, info, rs)) continue;
                    rc = false;
                    break;
                }
                if (str.startsWith("/")) {
                    ++info.commentCount;
                    continue;
                }
                codeFound = true;
                ++info.codeCount;
            }
            info.totalLines = in.getLineNumber();
            in.close();
        }
        catch (IOException e) {
            rs.addResult(4, e.toString());
            rs.lastResult().moreMessages("Occurred while reading file: " + fullname);
            rc = false;
        }
        if (rc) {
            this.addCountInfo(info);
        }
        return rc;
    }

    boolean processBlock(String curr, LineNumberReader in, CodeCountInfo info, ResultSet rs) {
        boolean rc = true;
        if (curr.lastIndexOf("*/") != -1) {
            if (curr.startsWith("/*") && curr.endsWith("*/")) {
                ++info.commentCount;
                return rc;
            }
            ++info.codeCount;
            return rc;
        }
        try {
            String str;
            int startLine = in.getLineNumber();
            while ((str = in.readLine()) != null) {
                if (str.lastIndexOf("*/") == -1) continue;
                info.commentCount += in.getLineNumber() - startLine + 1;
                break;
            }
        }
        catch (IOException e) {
            rs.addResult(4, e.toString());
            rs.lastResult().moreMessages("Occurred while reading file: " + info.fileName);
            rc = false;
        }
        return rc;
    }

    void addCountInfo(CodeCountInfo info) {
        TreeMap<String, CodeCountInfo> curr = this.packages.get(info.packageName);
        if (curr == null) {
            curr = new TreeMap();
            this.packages.put(info.packageName, curr);
        }
        curr.put(info.fileName, info);
    }

    void dumpInfo() {
        Iterator<String> packit = this.packages.keySet().iterator();
        TreeMap<String, CodeCountInfo> infotree = null;
        Iterator<CodeCountInfo> infoit = null;
        String pname = null;
        CodeCountInfo info2 = null;
        int regFiles = 0;
        int autoFiles = 0;
        int regFilesG = 0;
        int autoFilesG = 0;
        int stotal = 0;
        int ctotal = 0;
        int itotal = 0;
        int btotal = 0;
        int gtotal = 0;
        int astotal = 0;
        int actotal = 0;
        int aitotal = 0;
        int abtotal = 0;
        int agtotal = 0;
        int stotalG = 0;
        int ctotalG = 0;
        int itotalG = 0;
        int btotalG = 0;
        int gtotalG = 0;
        int astotalG = 0;
        int actotalG = 0;
        int aitotalG = 0;
        int abtotalG = 0;
        int agtotalG = 0;
        while (packit.hasNext()) {
            gtotal = 0;
            btotal = 0;
            itotal = 0;
            ctotal = 0;
            stotal = 0;
            agtotal = 0;
            abtotal = 0;
            aitotal = 0;
            actotal = 0;
            astotal = 0;
            autoFiles = 0;
            regFiles = 0;
            pname = packit.next();
            this.println(pname + ":");
            this.println(this.nameFormat.sprintf("File") + this.colFormat.sprintf("Src") + this.colFormat.sprintf("Comment") + this.colFormat.sprintf("Import") + this.colFormat.sprintf("Blank") + this.colFormat.sprintf("Total"));
            infotree = this.packages.get(pname);
            for (CodeCountInfo info2 : infotree.values()) {
                this.println(info2.formatInfo(this.nameFormat, this.numFormat));
                if (info2.auto) {
                    astotal += info2.codeCount;
                    actotal += info2.commentCount;
                    aitotal += info2.importCount;
                    abtotal += info2.blankCount;
                    agtotal += info2.totalLines;
                    ++autoFiles;
                    continue;
                }
                stotal += info2.codeCount;
                ctotal += info2.commentCount;
                itotal += info2.importCount;
                btotal += info2.blankCount;
                gtotal += info2.totalLines;
                ++regFiles;
            }
            this.println(this.totalFormat.sprintf("Regular files:") + this.numFormat.sprintf(stotal) + this.numFormat.sprintf(ctotal) + this.numFormat.sprintf(itotal) + this.numFormat.sprintf(btotal) + this.numFormat.sprintf(gtotal));
            this.println(this.totalFormat.sprintf("Auto-generated:") + this.numFormat.sprintf(astotal) + this.numFormat.sprintf(actotal) + this.numFormat.sprintf(aitotal) + this.numFormat.sprintf(abtotal) + this.numFormat.sprintf(agtotal));
            this.println(this.totalFormat.sprintf("Package total:") + this.numFormat.sprintf(stotal + astotal) + this.numFormat.sprintf(ctotal + actotal) + this.numFormat.sprintf(itotal + aitotal) + this.numFormat.sprintf(btotal + abtotal) + this.numFormat.sprintf(gtotal + agtotal) + "\n");
            stotalG += stotal;
            ctotalG += ctotal;
            itotalG += itotal;
            btotalG += btotal;
            gtotalG += gtotal;
            astotalG += astotal;
            actotalG += actotal;
            aitotalG += aitotal;
            abtotalG += abtotal;
            agtotalG += agtotal;
            regFilesG += regFiles;
            autoFilesG += autoFiles;
        }
        this.println("\n");
        this.println(this.nameFormat.sprintf("System Totals") + this.colFormat.sprintf("Src") + this.colFormat.sprintf("Comment") + this.colFormat.sprintf("Import") + this.colFormat.sprintf("Blank") + this.colFormat.sprintf("Total"));
        this.println(this.totalFormat.sprintf("Regular files:") + this.numFormat.sprintf(stotalG) + this.numFormat.sprintf(ctotalG) + this.numFormat.sprintf(itotalG) + this.numFormat.sprintf(btotalG) + this.numFormat.sprintf(gtotalG));
        this.println(this.totalFormat.sprintf("Auto-generated:") + this.numFormat.sprintf(astotalG) + this.numFormat.sprintf(actotalG) + this.numFormat.sprintf(aitotalG) + this.numFormat.sprintf(abtotalG) + this.numFormat.sprintf(agtotalG));
        this.println(this.totalFormat.sprintf("System totals:") + this.numFormat.sprintf(stotalG + astotalG) + this.numFormat.sprintf(ctotalG + actotalG) + this.numFormat.sprintf(itotalG + aitotalG) + this.numFormat.sprintf(btotalG + abtotalG) + this.numFormat.sprintf(gtotalG + agtotalG) + "\n");
        this.println(this.nameFormat.sprintf("File count:"));
        this.println(this.totalFormat.sprintf("Regular files:") + regFilesG);
        this.println(this.totalFormat.sprintf("Auto-generated:") + autoFilesG);
        this.println(this.totalFormat.sprintf("Total:") + (regFilesG + autoFilesG));
    }

    void println(String s) {
        if (this.out == null) {
            System.out.println(s);
        } else {
            try {
                this.out.write(s + "\n");
            }
            catch (IOException e) {
                System.out.println("IO Error:\n" + e);
                System.exit(1);
            }
        }
    }
}

