/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.util.debug;

import java.util.ArrayList;
import java.util.Iterator;
import org.dmd.util.debug.DebugCategoryIF;
import org.dmd.util.debug.DebugChannel;
import org.dmd.util.debug.DebugChannelIF;
import org.dmd.util.debug.DebugManager;

public class DebugCategory
implements DebugCategoryIF {
    String name;
    ArrayList<String> tags;
    String description;
    DebugChannel channel;

    public DebugCategory(String n, String d, String ... t) {
        this.name = n;
        this.description = d;
        this.tags = new ArrayList();
        for (String s : t) {
            this.tags.add(s);
        }
        DebugManager.instance().advertise(this);
    }

    @Override
    public Iterator<String> getTags() {
        return this.tags.iterator();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public DebugChannelIF initializeChannel(String uniqueName) {
        if (this.channel == null) {
            this.channel = new DebugChannel(this, uniqueName);
            return this.channel;
        }
        throw new IllegalStateException("initializeChannel() has been called multiple times for DebugCategory: " + this.name);
    }

    @Override
    public DebugChannelIF getChannel() {
        return this.channel;
    }
}

