/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.util.debug;

import java.util.ArrayList;
import org.dmd.util.debug.DebugCategoryIF;
import org.dmd.util.debug.DebugChannelIF;
import org.dmd.util.debug.DebugHandlerIF;

public class DebugChannel
implements DebugChannelIF {
    DebugCategoryIF category;
    String uniqueName;
    final ArrayList<DebugHandlerIF> handlers;

    public DebugChannel(DebugCategoryIF cat, String un) {
        this.category = cat;
        this.handlers = new ArrayList(0);
        this.uniqueName = un;
    }

    @Override
    public DebugCategoryIF getCategory() {
        return this.category;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(String message) {
        ArrayList<DebugHandlerIF> arrayList = this.handlers;
        synchronized (arrayList) {
            if (this.handlers.size() > 0) {
                for (DebugHandlerIF h : this.handlers) {
                    h.handleDebug(this.category, message);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribe(DebugHandlerIF h) {
        ArrayList<DebugHandlerIF> arrayList = this.handlers;
        synchronized (arrayList) {
            this.handlers.add(h);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unsubscribe(DebugHandlerIF h) {
        ArrayList<DebugHandlerIF> arrayList = this.handlers;
        synchronized (arrayList) {
            this.handlers.remove(h);
        }
    }

    @Override
    public String getUniqueName() {
        return this.uniqueName;
    }
}

