/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.util.debug;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import org.dmd.util.debug.DebugCategoryIF;
import org.dmd.util.debug.DebugChannelIF;
import org.dmd.util.debug.DebugHandlerIF;
import org.dmd.util.exceptions.DebugInfo;

public class DebugManager {
    static DebugManager singleton;
    static final ArrayList<DebugCategoryIF> emptyList;
    TreeMap<String, DebugCategoryIF> categories = new TreeMap();
    TreeMap<String, ArrayList<DebugCategoryIF>> categoriesByTag = new TreeMap();
    TreeMap<String, ArrayList<DebugHandlerIF>> preregisters = new TreeMap();

    private DebugManager() {
    }

    public static DebugManager instance() {
        if (singleton == null) {
            singleton = new DebugManager();
        }
        return singleton;
    }

    public void preregister(DebugHandlerIF handler, String tag) {
        ArrayList<DebugHandlerIF> handlers = this.preregisters.get(tag);
        if (handlers == null) {
            handlers = new ArrayList();
            this.preregisters.put(tag, handlers);
        }
        handlers.add(handler);
    }

    public DebugChannelIF advertise(DebugCategoryIF dc) {
        String from = DebugInfo.getWhereWeWereCalledFrom();
        String unique = "";
        int anglePos = from.indexOf(60);
        unique = anglePos != -1 ? from.substring(13, anglePos - 1) + "-" + dc.getName() + "-" + this.categories.size() : from.substring(13) + "-" + dc.getName() + "-" + this.categories.size();
        this.categories.put(unique, dc);
        Iterator<String> tags = dc.getTags();
        while (tags.hasNext()) {
            String tag = tags.next();
            ArrayList<DebugCategoryIF> channels = this.categoriesByTag.get(tag);
            if (channels == null) {
                channels = new ArrayList();
            }
            channels.add(dc);
        }
        DebugChannelIF rc = dc.initializeChannel(unique);
        tags = dc.getTags();
        while (tags.hasNext()) {
            String tag = tags.next();
            ArrayList<DebugHandlerIF> handlers = this.preregisters.get(tag);
            if (handlers == null) continue;
            for (DebugHandlerIF h : handlers) {
                dc.getChannel().subscribe(h);
            }
        }
        return rc;
    }

    public Iterator<DebugCategoryIF> getCategoriesByTag(String tag) {
        ArrayList<DebugCategoryIF> cats = this.categoriesByTag.get(tag);
        if (cats == null) {
            return emptyList.iterator();
        }
        return cats.iterator();
    }

    public Iterator<DebugCategoryIF> getCategories() {
        return this.categories.values().iterator();
    }

    static {
        emptyList = new ArrayList();
    }
}

