/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.util.exceptions;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.util.StringTokenizer;

public class DebugInfo {
    public static String getCurrentStack() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        new Throwable().printStackTrace(printWriter);
        StringBuffer sb = new StringBuffer(stringWriter.toString());
        String trace = new String(stringWriter.toString());
        sb.delete(0, trace.indexOf(")") + 1);
        return new String(sb.toString());
    }

    public static String getWhereWeWereCalledFrom() {
        String currStack = DebugInfo.getCurrentStack();
        int firstBracket = currStack.indexOf(41);
        int secondBracket = currStack.indexOf(41, firstBracket + 1);
        int thirdBracket = currStack.indexOf(41, secondBracket + 1);
        return "Called from: " + currStack.substring(secondBracket + 6, thirdBracket + 1).trim();
    }

    public static String getShortWhereWeWereCalledFrom() {
        String currStack = DebugInfo.getCurrentStack();
        int firstBracket = currStack.indexOf(41);
        int secondBracket = currStack.indexOf(41, firstBracket + 1);
        int thirdOpen = currStack.indexOf(40, secondBracket + 1);
        int thirdBracket = currStack.indexOf(41, secondBracket + 1);
        return currStack.substring(thirdOpen, thirdBracket + 1);
    }

    public static String getWhereWeAreNow() {
        String currStack = DebugInfo.getCurrentStack();
        int firstBracket = currStack.indexOf(41);
        int secondBracket = currStack.indexOf(41, firstBracket + 1);
        return currStack.substring(firstBracket + 6, secondBracket + 1).trim();
    }

    public static String getWhereWeAreNowShort() {
        String currStack = DebugInfo.getCurrentStack();
        int firstBracket = currStack.indexOf(41);
        int secondBracket = currStack.indexOf(41, firstBracket + 1);
        String line = currStack.substring(firstBracket + 6, secondBracket + 1).trim();
        firstBracket = line.indexOf(40);
        secondBracket = line.indexOf(41, firstBracket + 1);
        return line.substring(firstBracket + 1, secondBracket).trim();
    }

    public static String getCurrentMethod() {
        int iclass;
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        new Throwable().printStackTrace(printWriter);
        String fullInfo = new String(stringWriter.toString());
        String token = null;
        String methodName = null;
        StringTokenizer tokenizer = new StringTokenizer(fullInfo, " ");
        if (tokenizer.countTokens() < 2) {
            return "NA";
        }
        for (int i = 0; i < 3; ++i) {
            token = tokenizer.nextToken();
        }
        int iend = token.lastIndexOf(40);
        int imethod = token.lastIndexOf(46, iend);
        methodName = imethod == -1 ? "NA" : ((iclass = token.lastIndexOf(46, imethod - 1)) == -1 ? "NA" : token.substring(iclass + 1, iend));
        return methodName;
    }

    public static String getCompleteCurrentMethod() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        new Throwable().printStackTrace(printWriter);
        String fullInfo = new String(stringWriter.toString());
        String token = null;
        String methodName = null;
        StringTokenizer tokenizer = new StringTokenizer(fullInfo, " ");
        if (tokenizer.countTokens() < 2) {
            return "NA";
        }
        for (int i = 0; i < 3; ++i) {
            token = tokenizer.nextToken();
        }
        int iend = token.lastIndexOf(40);
        if (iend == -1) {
            return "NA";
        }
        methodName = token.substring(0, iend);
        return methodName;
    }

    public static void getCurrentLine() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        new Throwable().printStackTrace(printWriter);
        String fullInfo = new String(stringWriter.toString());
        String lineNumber = null;
        if (fullInfo.length() == 0) {
            lineNumber = "NA";
        }
        if (lineNumber == null) {
            int iend = fullInfo.lastIndexOf(41);
            int ibegin = fullInfo.lastIndexOf(58, iend - 1);
            lineNumber = ibegin == -1 ? "-1" : fullInfo.substring(ibegin + 1, iend);
        }
        System.out.println(lineNumber);
    }

    public static String getCurrentLineNumber() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        new Throwable().printStackTrace(printWriter);
        String fullInfo = new String(stringWriter.toString());
        String lineNumber = null;
        if (fullInfo.length() == 0) {
            lineNumber = "NA";
        }
        if (lineNumber == null) {
            int iend = fullInfo.lastIndexOf(41);
            int ibegin = fullInfo.lastIndexOf(58, iend - 1);
            lineNumber = ibegin == -1 ? "-1" : fullInfo.substring(ibegin + 1, iend);
        }
        return lineNumber;
    }

    public static String getEnumerationString(Class obj, int value) {
        String taskName = Integer.toString(value);
        try {
            Field[] fields = obj.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                try {
                    if (field.getInt(null) != value) continue;
                    taskName = field.getName();
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return taskName;
    }

    public static void debugWithTrace(String s) {
        System.out.print(s);
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        new Throwable().printStackTrace(printWriter);
        StringBuffer sb = new StringBuffer(stringWriter.toString());
        String trace = new String(stringWriter.toString());
        sb.delete(0, trace.indexOf(")") + 1);
        System.out.println(sb.toString());
    }

    public static void debug(String s) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        new Throwable().printStackTrace(printWriter);
        String fullInfo = new String(stringWriter.toString());
        String token = null;
        String methodName = null;
        StringTokenizer tokenizer = new StringTokenizer(fullInfo, " ");
        if (tokenizer.countTokens() < 2) {
            System.out.println("NA - " + s);
            return;
        }
        for (int i = 0; i < 3; ++i) {
            token = tokenizer.nextToken();
        }
        int iend = token.lastIndexOf(40);
        if (iend == -1) {
            System.out.println("NA - " + s);
            return;
        }
        methodName = token.substring(0, iend);
        System.out.println(methodName + " - " + s);
    }

    public static String extractTheStack(Exception ex) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        return sw.toString();
    }
}

