/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.util.exceptions;

import java.util.ArrayList;

public class Result {
    public static final int NONE = 0;
    public static final int INFO = 1;
    public static final int WARNING = 2;
    public static final int ERROR = 3;
    public static final int FATAL = 4;
    public static final int CAT_SOFTWARE = 1;
    public static final int CAT_SECURITY = 2;
    public static final int CAT_DATABASE = 3;
    public static final int CAT_COMMS = 4;
    public static final int CAT_OPERATIONAL = 5;
    private StringBuffer messageV;
    private ArrayList<StringBuffer> moreMessagesV;
    private int moreCountV;
    private int severityV;
    private int categoryV;
    private StringBuffer fileNameV;
    private int lineNumberV;
    private int nearLineNumberV;
    private StringBuffer attrNameV;
    private int uniqueIDV;

    Result() {
        this.messageV = new StringBuffer();
        this.moreMessagesV = new ArrayList();
        this.moreCountV = 0;
        this.severityV = 0;
        this.categoryV = 0;
        this.fileNameV = new StringBuffer();
        this.lineNumberV = -1;
        this.nearLineNumberV = -1;
        this.attrNameV = new StringBuffer();
        this.uniqueIDV = -1;
    }

    Result(String msg, String file, int line) {
        this.severityV = 3;
        this.messageV = new StringBuffer(msg);
        this.fileNameV = new StringBuffer(file);
        this.lineNumberV = line;
    }

    public Result(Result r) {
        this.messageV = new StringBuffer(r.messageV.toString());
        this.moreMessagesV = new ArrayList();
        this.moreCountV = 0;
        for (int i = 0; i < r.moreMessagesV.size(); ++i) {
            this.moreMessagesV.add(new StringBuffer(r.moreMessagesV.get(i).toString()));
            ++this.moreCountV;
        }
        this.severityV = r.severityV;
        this.categoryV = r.categoryV;
        this.fileNameV = r.fileNameV.length() == 0 ? new StringBuffer() : new StringBuffer(r.fileNameV.toString());
        this.lineNumberV = r.lineNumberV;
        this.nearLineNumberV = r.nearLineNumberV;
        this.attrNameV = r.attrNameV.length() == 0 ? new StringBuffer() : new StringBuffer(r.attrNameV.toString());
        this.uniqueIDV = r.uniqueIDV;
    }

    public void reset() {
        this.messageV.delete(0, this.messageV.length());
        for (int i = 0; i < this.moreCountV; ++i) {
            StringBuffer sb = this.moreMessagesV.get(i);
            sb.delete(0, sb.length());
        }
        this.moreCountV = 0;
        this.severityV = 0;
        this.categoryV = 0;
        this.fileNameV.delete(0, this.fileNameV.length());
        this.lineNumberV = -1;
        this.nearLineNumberV = -1;
        this.attrNameV.delete(0, this.attrNameV.length());
        this.uniqueIDV = -1;
    }

    public void reset(int sev, String txt) {
        this.reset();
        this.severityV = sev;
        this.messageV.append(txt);
    }

    public int severity() {
        return this.severityV;
    }

    public int category() {
        return this.categoryV;
    }

    public void severity(int s) {
        switch (s) {
            case 0: {
                this.severityV = s;
                break;
            }
            case 1: {
                this.severityV = s;
                break;
            }
            case 2: {
                this.severityV = s;
                break;
            }
            case 3: {
                this.severityV = s;
                break;
            }
            case 4: {
                this.severityV = s;
                break;
            }
            default: {
                this.severityV = 0;
            }
        }
    }

    public void category(int c) {
        switch (c) {
            case 1: {
                this.categoryV = c;
                break;
            }
            case 2: {
                this.categoryV = c;
                break;
            }
            case 3: {
                this.categoryV = c;
                break;
            }
            case 4: {
                this.categoryV = c;
                break;
            }
            case 5: {
                this.categoryV = c;
                break;
            }
            default: {
                this.categoryV = 0;
            }
        }
    }

    public String message() {
        return this.messageV.toString();
    }

    public void message(String s) {
        this.messageV.delete(0, this.messageV.length());
        this.messageV.append(s);
    }

    public ArrayList<StringBuffer> moreMessages() {
        return this.moreMessagesV;
    }

    public void moreMessages(String s) {
        StringBuffer sb = null;
        if (this.moreCountV + 1 > this.moreMessagesV.size()) {
            sb = new StringBuffer();
            this.moreMessagesV.add(sb);
        } else {
            sb = this.moreMessagesV.get(this.moreCountV);
        }
        sb.append(s);
        ++this.moreCountV;
    }

    public String fileName() {
        return this.fileNameV.toString();
    }

    public void fileName(String s) {
        this.fileNameV.delete(0, this.fileNameV.length());
        this.fileNameV.append(s);
    }

    public int lineNumber() {
        return this.lineNumberV;
    }

    public void lineNumber(int i) {
        this.lineNumberV = i > 0 ? i : -1;
        this.nearLineNumberV = -1;
    }

    public int nearLineNumber() {
        return this.nearLineNumberV;
    }

    public void nearLineNumber(int i) {
        this.nearLineNumberV = i > 0 ? i : -1;
        this.lineNumberV = -1;
    }

    public String attrName() {
        return this.attrNameV.toString();
    }

    public void attrName(String s) {
        this.attrNameV.delete(0, this.attrNameV.length());
        this.attrNameV.append(s);
    }

    public int uniqueID() {
        return this.uniqueIDV;
    }

    public void uniqueID(int i) {
        this.uniqueIDV = i > 0 ? i : -1;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        switch (this.severityV) {
            case 0: {
                sb.append("Info:      ");
                break;
            }
            case 1: {
                sb.append("Info:      ");
                break;
            }
            case 2: {
                sb.append("Warning:   ");
                break;
            }
            case 3: {
                sb.append("Error:     ");
                break;
            }
            case 4: {
                sb.append("Fatal:     ");
                break;
            }
            default: {
                sb.append("Info:      ");
            }
        }
        if (this.messageV.length() > 0) {
            sb.append(this.messageV.toString());
        }
        sb.append("\n");
        if (this.moreCountV > 0) {
            for (int i = 0; i < this.moreCountV; ++i) {
                sb.append("           " + this.moreMessagesV.get(i).toString() + "\n");
            }
        }
        if (this.categoryV != 0) {
            switch (this.categoryV) {
                case 1: {
                    sb.append("Category: SOFTWARE\n");
                    break;
                }
                case 2: {
                    sb.append("Category: SECURITY\n");
                    break;
                }
                case 3: {
                    sb.append("Category: DATABASE\n");
                    break;
                }
                case 4: {
                    sb.append("Category: COMMS\n");
                    break;
                }
                case 5: {
                    sb.append("Category: OPERATIONAL\n");
                    break;
                }
                default: {
                    sb.append("Category: NONE\n");
                }
            }
        }
        if (this.fileNameV.length() > 0) {
            sb.append("File:      " + this.fileNameV.toString() + "\n");
        }
        if (this.lineNumberV > 0) {
            sb.append("Line:      " + this.lineNumberV + "\n");
        }
        if (this.nearLineNumberV > 0) {
            sb.append("Near line: " + this.nearLineNumberV + "\n");
        }
        if (this.attrNameV.length() > 0) {
            sb.append("Attribute: " + this.attrNameV.toString() + "\n");
        }
        if (this.uniqueIDV > 0) {
            sb.append("Unique ID: " + this.uniqueIDV + "\n");
        }
        sb.append("\n");
        return sb.toString();
    }
}

