/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.util.exceptions;

import java.util.HashMap;
import java.util.Iterator;
import org.dmd.util.exceptions.DebugInfo;
import org.dmd.util.exceptions.Result;
import org.dmd.util.exceptions.ResultSet;

public class ResultException
extends Exception {
    private HashMap<String, Object> userData;
    public ResultSet result = new ResultSet();

    public ResultException() {
    }

    public ResultException(String s) {
        this.result.addResult(3, s);
    }

    public ResultException(Exception e) {
        this((String)null);
        this.addErrorWithStack(e.getMessage(), DebugInfo.extractTheStack(e));
    }

    public ResultException(ResultSet rs) {
        this(rs.lastResult() != null ? rs.lastResult().message() : "Empty result set", rs);
    }

    public ResultException(String s, ResultSet rs) {
        super(s);
        if (rs != null) {
            this.result.addResults(rs);
        }
    }

    public void userData(String key, Object value) {
        if (this.userData == null) {
            this.userData = new HashMap();
        }
        this.userData.put(key, value);
    }

    public Object userData(String key) {
        if (this.userData == null) {
            return null;
        }
        return this.userData.get(key);
    }

    @Override
    public String toString() {
        return this.result.toString();
    }

    public void populate(ResultSet rs) {
        if (this.result != null) {
            Iterator<Result> it = this.result.iterator();
            while (it.hasNext()) {
                Result r = it.next();
                rs.addResult(new Result(r));
            }
        }
    }

    public void addError(String msg) {
        this.result.addResult(3, msg);
    }

    public void addError(String msg, String file, int line) {
        this.result.addResult(new Result(msg, file, line));
    }

    public void addErrorWithStack(String msg, String stack) {
        this.result.addResult(3, msg);
        this.result.lastResult().moreMessages(stack);
    }

    public void addErrorWithStack(String msg, Exception exception) {
        this.result.addResult(3, msg);
        this.result.lastResult().moreMessages(DebugInfo.extractTheStack(exception));
    }

    public void addFatalWithStack(String msg, Exception exception) {
        this.result.addResult(4, msg);
        this.result.lastResult().moreMessages(DebugInfo.extractTheStack(exception));
    }

    public void setLocationInfo(String f, int l) {
        this.result.lastResult().fileName(f);
        this.result.lastResult().lineNumber(l);
    }

    public void moreMessages(String msg) {
        this.result.lastResult().moreMessages(msg);
    }
}

