/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.util.exceptions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import org.dmd.util.exceptions.Result;

public class ResultSet {
    ArrayList<Result> available = new ArrayList();
    ArrayList<Result> current = new ArrayList();
    int worstV = 0;
    int errorsV = 0;
    int warningsV = 0;
    Locale localeV;

    public ResultSet() {
        this.localeV = Locale.US;
    }

    public ResultSet(Locale l) {
        this.localeV = l;
    }

    public void reset() {
        while (this.current.size() > 0) {
            Result curr = this.current.remove(0);
            curr.reset();
            this.available.add(curr);
        }
        this.errorsV = 0;
        this.warningsV = 0;
        this.worstV = 0;
    }

    public Iterator<Result> iterator() {
        return this.current.iterator();
    }

    public Locale locale() {
        return this.localeV;
    }

    public int resultCount() {
        return this.current.size();
    }

    public int errors() {
        return this.errorsV;
    }

    public int warnings() {
        return this.warningsV;
    }

    public Result addResult(int sev, String message) {
        Result curr = this.available.size() > 0 ? this.available.remove(0) : new Result();
        curr.reset(sev, message);
        this.current.add(curr);
        if (sev > this.worstV) {
            this.worstV = sev;
        }
        if (sev == 3 || sev == 4) {
            ++this.errorsV;
        }
        if (sev == 2) {
            ++this.warningsV;
        }
        return curr;
    }

    public Result addResult(Result r) {
        Result curr = new Result(r);
        this.current.add(curr);
        if (curr.severity() > this.worstV) {
            this.worstV = curr.severity();
        }
        if (curr.severity() == 3 || curr.severity() == 4) {
            ++this.errorsV;
        }
        if (curr.severity() == 2) {
            ++this.warningsV;
        }
        return curr;
    }

    public Result lastResult() {
        if (this.current.size() == 0) {
            return null;
        }
        return this.current.get(this.current.size() - 1);
    }

    public int worst() {
        return this.worstV;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.current.size(); ++i) {
            sb.append(this.current.get(i).toString());
        }
        return sb.toString();
    }

    public void addResults(ResultSet rs) {
        for (int i = 0; i < rs.current.size(); ++i) {
            Result r = rs.current.get(i);
            this.addResult(r);
        }
    }
}

