/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.util.formatting;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Iterator;
import org.dmd.util.exceptions.DebugInfo;

public class CodeFormatter {
    public static void dumpCodeComment(String comment, BufferedWriter out, String indent) throws IOException {
        StringBuffer sb = new StringBuffer();
        sb.append(comment);
        while (sb.length() > 75) {
            int offset = 74;
            while (sb.charAt(offset) != ' ') {
                if (--offset != -1) continue;
                DebugInfo.debug("comment = " + comment);
            }
            out.write(indent);
            for (int i = 0; i < offset; ++i) {
                out.write(sb.charAt(i));
            }
            out.write("\n");
            sb.delete(0, offset + 1);
        }
        out.write(indent + sb + "\n");
    }

    public static void dumpCodeComment(String comment, StringBuffer out, String indent) {
        StringBuffer sb = new StringBuffer();
        sb.append(comment);
        while (sb.length() > 75) {
            int offset = 74;
            while (sb.charAt(offset) != ' ') {
                --offset;
            }
            out.append(indent);
            for (int i = 0; i < offset; ++i) {
                out.append(sb.charAt(i));
            }
            out.append("\n");
            sb.delete(0, offset + 1);
        }
        out.append(indent + sb + "\n");
    }

    public static String getTheClass(String fullyQualified) {
        int lastDot = fullyQualified.lastIndexOf(".");
        return fullyQualified.substring(lastDot + 1);
    }

    public static String foldFullyQualified(String fullyQualified, int maxLength) {
        if (fullyQualified.length() < maxLength) {
            return fullyQualified;
        }
        StringBuffer sb = new StringBuffer();
        StringBuffer part = new StringBuffer();
        String[] parts = fullyQualified.split("\\.");
        for (int i = 0; i < parts.length; ++i) {
            if (part.length() + parts[i].length() + 1 > maxLength) {
                sb.append(part + "\n");
                part = new StringBuffer();
            }
            if (i > 0) {
                part.append(".");
            }
            part.append(parts[i]);
        }
        sb.append(part + "\n");
        return sb.toString();
    }

    public static void dumpCodeComment(Iterator<String> description, StringBuffer out, String indent) {
        StringBuffer sb = new StringBuffer();
        if (description == null) {
            return;
        }
        while (description.hasNext()) {
            String str = description.next();
            sb.append(str);
            if (!description.hasNext()) continue;
            sb.append("\n");
        }
        while (sb.length() > 75) {
            int offset = 74;
            while (sb.charAt(offset) != ' ') {
                --offset;
            }
            out.append(indent);
            for (int i = 0; i < offset; ++i) {
                out.append(sb.charAt(i));
            }
            out.append("\n");
            sb.delete(0, offset + 1);
        }
        out.append(indent + sb + "\n");
    }

    public static void dumpCodeComment(Iterator<String> description, BufferedWriter out, String indent) throws IOException {
        StringBuffer sb = new StringBuffer();
        if (description == null) {
            return;
        }
        while (description.hasNext()) {
            String str = description.next();
            sb.append(str);
            if (!description.hasNext()) continue;
            sb.append("\n");
        }
        while (sb.length() > 75) {
            int offset = 74;
            while (sb.charAt(offset) != ' ') {
                --offset;
            }
            out.write(indent);
            for (int i = 0; i < offset; ++i) {
                out.write(sb.charAt(i));
            }
            out.write("\n");
            sb.delete(0, offset + 1);
        }
        out.write(indent + sb + "\n");
    }
}

