/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.util.parsing;

import java.util.ArrayList;
import org.dmd.dmc.types.IntegerVar;

public class CSVRowSplitter {
    public static ArrayList<String> split(String row) {
        ArrayList<String> rc = new ArrayList<String>();
        if (row == null || row.length() == 0) {
            return rc;
        }
        String input = row.trim();
        input = input.replaceAll("\"\"", "");
        while (input.indexOf(",,") != -1) {
            input = input.replaceAll(",,", ",null,");
        }
        if (input.endsWith(",")) {
            input = input + "null";
        }
        IntegerVar position = new IntegerVar();
        int valueStart = 0;
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) == ',') {
                if (valueStart == i) {
                    ++valueStart;
                    continue;
                }
                rc.add(input.substring(valueStart, i));
                valueStart = i + 1;
                continue;
            }
            if (input.charAt(i) != '\"') continue;
            position.set(i);
            rc.add(CSVRowSplitter.parseQuotedText(input, position));
            i = position.intValue();
            valueStart = i + 1;
        }
        if (valueStart < input.length()) {
            rc.add(input.substring(valueStart));
        }
        return rc;
    }

    static String parseQuotedText(String input, IntegerVar position) {
        String rc = "";
        for (int i = position.intValue() + 1; i < input.length(); ++i) {
            if (input.charAt(i) != '\"') continue;
            rc = input.substring(position.intValue() + 1, i);
            position.set(i);
            break;
        }
        return rc;
    }
}

