/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.util.parsing;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.dmd.util.parsing.Dictionary;
import org.dmd.util.parsing.Token;

public class ClassifierNew {
    private Dictionary dict;
    private Dictionary separators;
    private StringBuffer delimiters;
    private static String defaultDelimiters = new String(" \t\r\n\f");

    public ClassifierNew() {
        this.dict = new Dictionary();
        this.separators = new Dictionary();
        this.delimiters = new StringBuffer(defaultDelimiters);
    }

    public ClassifierNew(Dictionary d) {
        this.dict = d;
        this.separators = new Dictionary();
        this.delimiters = new StringBuffer(defaultDelimiters);
    }

    public ClassifierNew(Dictionary d, boolean useDefaults) {
        this.dict = d;
        this.separators = new Dictionary();
        this.delimiters = useDefaults ? new StringBuffer(defaultDelimiters) : new StringBuffer();
    }

    public boolean addKeyword(String k, int i) {
        return this.dict.add(k, i);
    }

    public boolean isKeyWord(String k) {
        return this.dict.find(k) != null;
    }

    public boolean addSeparator(String c, int i) {
        boolean rc = true;
        rc = this.separators.add(c, i);
        if (rc) {
            if (i > this.dict.getMaxID()) {
                this.dict.setMaxID(i);
            }
            this.delimiters.append(c);
        }
        return rc;
    }

    public ArrayList<Token> classify(String s, boolean returnSeps) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        String curr = null;
        Token sep = null;
        Token key = null;
        int tokenPos = 0;
        Token lastToken = null;
        StringTokenizer st = new StringTokenizer(s, this.delimiters.toString(), true);
        while (st.hasMoreTokens()) {
            lastToken = null;
            curr = st.nextToken();
            key = this.dict.find(curr);
            if (curr.length() == 1) {
                sep = this.separators.find(curr);
                if (Character.isWhitespace(curr.charAt(0))) {
                    lastToken = null;
                } else if (sep != null) {
                    if (returnSeps) {
                        lastToken = new Token(sep);
                        tokens.add(lastToken);
                    }
                } else if (key != null) {
                    lastToken = new Token(key);
                    tokens.add(lastToken);
                } else {
                    lastToken = new Token(curr, this.getType(curr));
                    tokens.add(lastToken);
                }
            } else if (key != null) {
                lastToken = new Token(key);
                tokens.add(lastToken);
            } else {
                lastToken = new Token(curr, this.getType(curr));
                tokens.add(lastToken);
            }
            if (lastToken == null) {
                ++tokenPos;
                continue;
            }
            lastToken.setPos(tokenPos);
            tokenPos += lastToken.getValue().length();
        }
        return tokens;
    }

    private int getType(String s) {
        int rc = 2;
        if (this.isInteger(s)) {
            rc = 4;
        } else if (this.isFloat(s)) {
            rc = 5;
        }
        return rc;
    }

    private boolean isInteger(String s) {
        boolean rc = true;
        try {
            Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            rc = false;
        }
        return rc;
    }

    private boolean isFloat(String s) {
        boolean rc = true;
        try {
            Float.parseFloat(s);
        }
        catch (NumberFormatException e) {
            rc = false;
        }
        return rc;
    }
}

