/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.util.parsing;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.dmd.util.exceptions.ResultException;
import org.dmd.util.parsing.ConfigLocation;
import org.dmd.util.parsing.ConfigVersion;

public class ConfigFinder {
    ArrayList<String> sourceDirs;
    ArrayList<String> suffixes;
    boolean checkClassPath;
    ArrayList<String> jarPrefixes;
    ArrayList<ConfigLocation> configs;
    ArrayList<String> classPaths;
    TreeMap<String, ConfigVersion> versions;
    String fsep;
    int longest;
    boolean debug = false;

    public ConfigFinder() {
        this.init();
    }

    public ConfigFinder(String suffix) {
        this.init();
        this.suffixes.add(suffix);
    }

    public ConfigFinder(String suffix, ArrayList<String> sd, boolean cp) {
        this.init();
        this.suffixes.add(suffix);
        for (String src : sd) {
            this.sourceDirs.add(src);
        }
        this.checkClassPath = cp;
    }

    public void setSourceInfo(ArrayList<String> sd) {
        for (String src : sd) {
            this.sourceDirs.add(src);
        }
    }

    public void setSourceAndJarInfo(ArrayList<String> sd, ArrayList<String> jars) {
        for (String src : sd) {
            this.sourceDirs.add(src);
        }
        for (String jar : jars) {
            this.jarPrefixes.add(jar);
        }
    }

    public ConfigFinder(Iterator<String> srcdirs) {
        this.init();
        while (srcdirs.hasNext()) {
            this.sourceDirs.add(srcdirs.next());
        }
    }

    public void debug(boolean db) {
        this.debug = db;
    }

    void debugMessage(String message) {
        if (this.debug) {
            System.out.println(message);
        }
    }

    void init() {
        this.debugMessage("ConfigFinder.initializing()");
        this.sourceDirs = new ArrayList();
        this.suffixes = new ArrayList();
        this.jarPrefixes = new ArrayList();
        this.configs = new ArrayList();
        this.versions = new TreeMap();
        this.fsep = File.separator;
        this.checkClassPath = false;
        this.classPaths = new ArrayList();
    }

    public void addSuffix(String s) {
        this.suffixes.add(s);
    }

    public void addJarPrefix(String e) {
        this.jarPrefixes.add(e);
    }

    public void addSourceDirectory(String dir) {
        this.sourceDirs.add(dir);
    }

    public void findConfigs() throws ResultException, IOException {
        this.debugMessage("Finding configs:\n\n" + this.getSearchInfo() + "\n");
        if (this.suffixes.size() == 0) {
            ResultException ex = new ResultException("You must specify at least one suffix to hunt for using the addSuffix() method");
            throw ex;
        }
        for (String d : this.sourceDirs) {
            this.debugMessage("Source dir: " + d);
            this.findConfigsRecursive(new File(d));
        }
        if (this.jarPrefixes.size() > 0) {
            this.debugMessage("We have JAR prefixes, searching class path\n");
            this.checkClassPath = true;
        }
        if (this.checkClassPath) {
            this.findConfigsOnClassPath();
        }
        this.debugMessage("Config search complete: " + this.getSearchInfo() + "\n");
    }

    public ConfigVersion getConfig(String cn) {
        return this.versions.get(cn);
    }

    public TreeMap<String, ConfigVersion> getVersions() {
        return this.versions;
    }

    public Iterator<ConfigLocation> getLocations() {
        return this.configs.iterator();
    }

    public int getLongestName() {
        return this.longest;
    }

    public String getSearchInfo() {
        StringBuffer sb = new StringBuffer();
        sb.append("Source directory preferences from -srcdir option or added via addSourceDirectory():\n");
        for (String f : this.sourceDirs) {
            sb.append("    " + f + "\n");
        }
        sb.append("\n");
        sb.append("Checked the following locations on your class path:\n");
        for (String c : this.classPaths) {
            sb.append("    " + c + "\n");
        }
        sb.append("\n");
        if (this.jarPrefixes.size() > 0) {
            sb.append("    Checked JARs with the following prefixes:\n");
            for (String j : this.jarPrefixes) {
                sb.append("    " + j + "\n");
            }
            sb.append("\n");
        }
        sb.append("For config files with the following suffixes:\n");
        for (String s : this.suffixes) {
            sb.append("    " + s + "\n");
        }
        return sb.toString();
    }

    void findConfigsRecursive(File dir) throws ResultException, IOException {
        if (dir.exists()) {
            String[] files;
            this.debugMessage("Searching for configs in: " + dir.getCanonicalPath());
            for (String f : files = dir.list()) {
                for (String suffix : this.suffixes) {
                    if (f.endsWith(suffix)) {
                        if (f.startsWith("meta") || f.lastIndexOf(".") == -1) continue;
                        ConfigLocation newLocation = new ConfigLocation(f, dir.getCanonicalPath(), suffix);
                        this.addConfig(newLocation);
                        if (newLocation.getConfigName().length() <= this.longest) continue;
                        this.longest = newLocation.getConfigName().length();
                        continue;
                    }
                    String fullname = dir.getAbsolutePath() + File.separator + f;
                    File curr = new File(fullname);
                    if (!curr.isDirectory()) continue;
                    this.findConfigsRecursive(curr);
                }
            }
        } else {
            String testdir = dir.getCanonicalPath();
            int lastSlash = testdir.lastIndexOf(File.separator);
            boolean partOkay = false;
            while (lastSlash != 0) {
                testdir = testdir.substring(0, lastSlash);
                lastSlash = testdir.lastIndexOf(File.separator);
                File test = new File(testdir);
                if (!test.exists()) continue;
                partOkay = true;
                break;
            }
            ResultException ex = new ResultException();
            ex.addError("Specified source directory doesn't exist: " + dir.getPath());
            if (partOkay) {
                ex.moreMessages("This part of the path is valid: " + testdir);
            }
            throw ex;
        }
    }

    void addConfig(ConfigLocation cl) throws ResultException {
        ConfigVersion cv = this.versions.get(cl.getConfigName());
        if (cv == null) {
            cv = new ConfigVersion();
            this.versions.put(cl.getConfigName(), cv);
        } else {
            ConfigLocation existing = cv.getLatestVersion();
            if (!cl.getConfigParentDirectory().equals(existing.getConfigParentDirectory())) {
                System.out.println("\nClashing config names: " + cl.configName);
                System.out.println("    " + existing.getConfigParentDirectory());
                System.out.println("    " + cl.getConfigParentDirectory() + "\n");
            }
        }
        cv.addVersion(cl);
        this.debugMessage("found config: " + cl.getConfigName());
        this.configs.add(cl);
    }

    void findConfigsOnClassPath() throws IOException, ResultException {
        String[] paths = System.getProperty("java.class.path").split(File.pathSeparator);
        this.debugMessage("findConfigsOnClassPath()");
        for (String f : paths) {
            this.debugMessage("    checking: " + f);
            if (this.jarPrefixes.size() > 0 && f.endsWith(".jar")) {
                this.debugMessage("\n    we have a jar - adding to classPaths");
                this.classPaths.add(f);
                for (String jarPrefix : this.jarPrefixes) {
                    this.debugMessage("    checking against prefix: " + jarPrefix);
                    String jarName = "";
                    int lastSlash = f.lastIndexOf(File.separator);
                    if (lastSlash != -1) {
                        jarName = f.substring(lastSlash + 1);
                    }
                    this.debugMessage("    jar name: " + jarName);
                    if (!jarName.startsWith(jarPrefix)) continue;
                    this.debugMessage("findConfigsOnClassPath() - jar starts with prefix " + f);
                    JarFile jar = new JarFile(f);
                    Enumeration<JarEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        String jarEntry = entries.nextElement().getName();
                        for (String suffix : this.suffixes) {
                            if (!jarEntry.endsWith(suffix)) continue;
                            lastSlash = jarEntry.lastIndexOf("/");
                            String schemaName = jarEntry.substring(lastSlash + 1);
                            String path = jarEntry.substring(0, lastSlash);
                            this.debugMessage("    jarEntry ends with suffix " + jarEntry);
                            ConfigLocation newLocation = new ConfigLocation(f, schemaName, path, suffix);
                            this.debugMessage("\n" + newLocation.toString() + "\n");
                            this.addConfig(newLocation);
                            if (newLocation.getConfigName().length() <= this.longest) continue;
                            this.longest = newLocation.getConfigName().length();
                        }
                    }
                    jar.close();
                }
                continue;
            }
            if (!f.endsWith(File.separator + "bin")) continue;
        }
    }
}

