/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.util.parsing;

import java.io.File;

public class ConfigLocation {
    String configName;
    String directory;
    String versionDirectory;
    String configParentDirectory;
    String fileName;
    String suffix;
    String version;
    String versionDotName;
    String jarFileName;
    String jarDirectory;
    String justJarName;

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ConfigLocation\n");
        sb.append("           configName: " + this.configName + "\n");
        sb.append("            directory: " + this.directory + "\n");
        sb.append("     versionDirectory: " + this.versionDirectory + "\n");
        sb.append("configParentDirectory: " + this.configParentDirectory + "\n");
        sb.append("             fileName: " + this.fileName + "\n");
        sb.append("               suffix: " + this.suffix + "\n");
        sb.append("              version: " + this.version + "\n");
        sb.append("       versionDotName: " + this.versionDotName + "\n");
        sb.append("          jarFileName: " + this.jarFileName + "\n");
        sb.append("         jarDirectory: " + this.jarDirectory + "\n\n");
        sb.append("          justJarName: " + this.justJarName + "\n\n");
        return sb.toString();
    }

    public ConfigLocation(String n, String dir, String s) {
        int lastSlash = -1;
        int dotpos = n.indexOf(".");
        this.configName = n.substring(0, dotpos);
        this.directory = dir;
        this.fileName = this.directory + File.separatorChar + n;
        this.suffix = s;
        lastSlash = this.directory.lastIndexOf(File.separatorChar);
        this.versionDirectory = this.directory;
        if (this.versionDirectory.indexOf("dot") == -1) {
            this.configParentDirectory = this.directory.substring(0, lastSlash);
            this.versionDirectory = null;
            this.version = "unknown";
        } else {
            lastSlash = this.versionDirectory.lastIndexOf(File.separatorChar);
            String tmp = this.versionDirectory.substring(0, lastSlash);
            lastSlash = tmp.lastIndexOf(File.separatorChar);
            this.configParentDirectory = tmp.substring(0, lastSlash);
            this.initializeVersion(File.separator);
        }
        this.jarFileName = null;
        this.jarDirectory = null;
        this.justJarName = null;
    }

    public boolean isFromJAR() {
        return this.jarFileName != null;
    }

    public ConfigLocation(String j, String n, String dir, String s) {
        String tmp;
        int lastSlash = -1;
        int lastDot = n.lastIndexOf(".");
        if (lastDot == -1) {
            throw new IllegalStateException("A config name must end with a . followed by an extension, this doesn't: " + n + "\nIn the following directory: " + dir);
        }
        this.configName = n.substring(0, lastDot);
        this.directory = dir;
        this.suffix = s;
        lastSlash = this.directory.lastIndexOf("/");
        this.versionDirectory = lastSlash == -1 ? this.directory : this.directory.substring(0, lastSlash);
        if (this.versionDirectory.indexOf("dot") == -1) {
            this.configParentDirectory = lastSlash == -1 ? "" : this.directory.substring(0, lastSlash);
            this.versionDirectory = null;
            this.version = "unknown";
        } else {
            lastSlash = this.versionDirectory.lastIndexOf("/");
            tmp = this.versionDirectory.substring(0, lastSlash);
            lastSlash = tmp.lastIndexOf("/");
            this.configParentDirectory = tmp.substring(0, lastSlash);
            this.initializeVersion("/");
        }
        this.jarFileName = j;
        this.jarDirectory = dir;
        tmp = "/" + this.jarDirectory + "/" + this.configName + this.suffix;
        this.fileName = tmp.replace('\\', '/');
        lastSlash = this.fileName.lastIndexOf("/");
        this.justJarName = this.fileName.substring(lastSlash + 1);
    }

    public String getConfigName() {
        return this.configName;
    }

    public String getDirectory() {
        return this.directory;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getConfigParentDirectory() {
        return this.configParentDirectory;
    }

    public String getVersion() {
        return this.version;
    }

    public String getJarFilename() {
        return this.jarFileName;
    }

    public String getJarDirectory() {
        return this.jarDirectory;
    }

    public String getJustJarFilename() {
        return this.justJarName;
    }

    void initializeVersion(String fs) {
        int lastSlash = this.directory.lastIndexOf(fs);
        String vstring = this.directory.substring(lastSlash + 1);
        vstring = vstring.substring(1);
        this.version = vstring.replaceAll("dot", ".");
        this.versionDotName = vstring;
    }
}

