/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.util.parsing;

import java.util.Map;
import java.util.TreeMap;
import org.dmd.util.exceptions.DebugInfo;
import org.dmd.util.exceptions.ResultException;
import org.dmd.util.parsing.ConfigLocation;

public class ConfigVersion {
    public static final String UNKNOWN = "unknown";
    TreeMap<String, ConfigLocation> versions = new TreeMap();
    String name;

    public void addVersion(ConfigLocation newVersion) throws ResultException {
        if (this.name == null) {
            this.name = newVersion.getConfigName();
        } else if (!this.name.equals(newVersion.getConfigName())) {
            ResultException ex = new ResultException("Name mismatch for ConfigVersion.");
            ex.result.lastResult().moreMessages(DebugInfo.getCurrentStack());
            throw ex;
        }
        ConfigLocation existing = this.versions.get(newVersion.getVersion());
        if (existing != null) {
            if (existing.getJarFilename() != null && newVersion.getJarFilename() != null) {
                if (existing.getJarFilename().equals(newVersion.getJarFilename())) {
                    return;
                }
                if (existing.getJustJarFilename().equals(newVersion.getJustJarFilename())) {
                    return;
                }
            }
            ResultException ex = new ResultException("Clashing versions for the " + this.name + " configuration file.");
            ex.result.lastResult().moreMessages("Originally from: " + existing.getFileName());
            if (existing.getJarFilename() != null) {
                ex.result.lastResult().moreMessages("              in .jar: " + existing.getJarFilename());
            }
            ex.result.lastResult().moreMessages("Clashing version from: " + newVersion.getFileName());
            if (newVersion.getJarFilename() != null) {
                ex.result.lastResult().moreMessages("              in .jar: " + newVersion.getJarFilename());
            }
            ex.result.lastResult().moreMessages(DebugInfo.getCurrentStack());
            throw ex;
        }
        this.versions.put(newVersion.getVersion(), newVersion);
    }

    public ConfigLocation getLatestVersion() {
        Map.Entry<String, ConfigLocation> entry = this.versions.lastEntry();
        return this.versions.get(entry.getKey());
    }
}

