/*
 * Decompiled with CFR 0.152.
 */
package org.dmd.util.parsing;

import java.util.Iterator;
import java.util.TreeMap;
import org.dmd.util.parsing.Token;

public class Dictionary {
    private TreeMap<String, Token> byString = new TreeMap();
    private TreeMap<Integer, Token> byType = new TreeMap();
    int maxId;

    public int getMaxID() {
        return this.maxId;
    }

    public void setMaxID(int i) {
        if (i > this.maxId) {
            this.maxId = i;
        }
    }

    public boolean add(Token t) {
        boolean rc = true;
        rc = this.checkAndAdd(t.getValue(), t, this.byString);
        if (rc) {
            if (t.getType() > this.maxId) {
                this.maxId = t.getType();
            }
            rc = this.checkAndAdd(new Integer(t.getType()), t, this.byType);
        }
        return rc;
    }

    public boolean add(String v, int t) {
        Token newt = new Token(v, t);
        return this.add(newt);
    }

    public Token find(String v) {
        return this.byString.get(v);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator<String> i = this.byString.keySet().iterator();
        Token t = null;
        while (i.hasNext()) {
            t = this.byString.get(i.next());
            sb.append(t.toString());
        }
        return new String(sb);
    }

    private boolean checkAndAdd(Object key, Object obj, TreeMap map) {
        if (map.containsKey(key)) {
            return false;
        }
        map.put(key, obj);
        return true;
    }
}

